/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends rr>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(Class<? extends rr> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(Class<? extends rr> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(entityClass, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(Class<? extends rr> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc2, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            this.entityNames.put(entityName, mc2);
            if (!rt.d.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc2.getModId(), entityName);
                rt.d.put(entityClass, entityModName);
                rt.c.put(entityModName, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc2.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc2.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARN, e2, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc2.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc2, (Object)er2);
    }

    public static void registerEgg(Class<? extends rr> entityClass, int primary, int secondary) {
        if (rt.d.containsKey(entityClass)) {
            String name = (String)rt.d.get(entityClass);
            rt.a.put(name, new rt.a(name, primary, secondary));
            FMLLog.fine("Registering entity egg '%s' for %s", name, entityClass);
        } else {
            FMLLog.fine("Failed registering entity egg %s (No entity found)", entityClass.getName());
        }
    }

    public static void addSpawn(Class<? extends sb> entityClass, int weightedProb, int min, int max, sc typeOfCreature, aig ... biomes) {
        for (aig biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            boolean found = false;
            for (aig.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new aig.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, sc typeOfCreature, aig ... biomes) {
        Class entityClazz = (Class)rt.c.get(entityName);
        if (sb.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends sb> entityClass, sc typeOfCreature, aig ... biomes) {
        for (aig biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                aig.c entry = (aig.c)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, sc typeOfCreature, aig ... biomes) {
        Class entityClazz = (Class)rt.c.get(entityName);
        if (sb.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    public EntityRegistration lookupModSpawn(Class<? extends rr> clazz, boolean keepLooking) {
        Class<? extends rr> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc2, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc2)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(ln entityTracker, rr entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends rr> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, rr> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc2, Class<? extends rr> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc2;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends rr> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public rr doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (rr)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, rr> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

