/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.apache.logging.log4j.Level;

public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList found = Lists.newArrayList();
        FMLLog.fine("Examining directory %s for potential mods", candidate.getModContainer().getName());
        this.exploreFileSystem("", candidate.getModContainer(), found, candidate, null);
        for (ModContainer mc2 : found) {
            table.addContainer(mc2);
        }
        return found;
    }

    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, MetadataCollection mc2) {
        if (path.length() == 0) {
            File metadata = new File(modDir, "mcmod.info");
            try {
                FileInputStream fis = new FileInputStream(metadata);
                mc2 = MetadataCollection.from(fis, modDir.getName());
                fis.close();
                FMLLog.fine("Found an mcmod.info file in directory %s", modDir.getName());
            }
            catch (Exception e2) {
                mc2 = MetadataCollection.from(null, "");
                FMLLog.fine("No mcmod.info file found in directory %s", modDir.getName());
            }
        }
        Object[] content = modDir.listFiles(new ClassFilter());
        Arrays.sort(content);
        for (Object file : content) {
            if (((File)file).isDirectory()) {
                FMLLog.finer("Recursing into package %s", path + ((File)file).getName());
                this.exploreFileSystem(path + ((File)file).getName() + "/", (File)file, harvestedMods, candidate, mc2);
                continue;
            }
            Matcher match = classFile.matcher(((File)file).getName());
            if (!match.matches()) continue;
            ASMModParser modParser = null;
            try {
                FileInputStream fis = new FileInputStream((File)file);
                modParser = new ASMModParser(fis);
                fis.close();
                candidate.addClassEntry(path + ((File)file).getName());
            }
            catch (LoaderException e3) {
                FMLLog.log(Level.ERROR, e3, "There was a problem reading the file %s - probably this is a corrupt file", ((File)file).getPath());
                throw e3;
            }
            catch (Exception e4) {
                Throwables.propagate((Throwable)e4);
            }
            modParser.validate();
            modParser.sendToTable(this.table, candidate);
            ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
            if (container == null) continue;
            harvestedMods.add(container);
            container.bindMetadata(mc2);
        }
    }

    private class ClassFilter
    implements FileFilter {
        private ClassFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && ITypeDiscoverer.classFile.matcher(file.getName()).matches() || file.isDirectory();
        }
    }
}

