/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers.deobf;

import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.RemappingMethodAdapter;

public class FMLRemappingAdapter
extends RemappingClassAdapter {
    public FMLRemappingAdapter(ClassVisitor cv2) {
        super(cv2, (Remapper)FMLDeobfuscatingRemapper.INSTANCE);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (interfaces == null) {
            interfaces = new String[]{};
        }
        FMLDeobfuscatingRemapper.INSTANCE.mergeSuperMaps(name, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor mv) {
        return new StaticFixingMethodVisitor(access, newDesc, mv, this.remapper);
    }

    private static class StaticFixingMethodVisitor
    extends RemappingMethodAdapter {
        public StaticFixingMethodVisitor(int access, String desc, MethodVisitor mv, Remapper remapper) {
            super(access, desc, mv, remapper);
        }

        public void visitFieldInsn(int opcode, String originalType, String originalName, String desc) {
            String replDesc;
            String type = this.remapper.mapType(originalType);
            String fieldName = this.remapper.mapFieldName(originalType, originalName, desc);
            String newDesc = this.remapper.mapDesc(desc);
            if (opcode == 178 && type.startsWith("net/minecraft/") && newDesc.startsWith("Lnet/minecraft/") && (replDesc = FMLDeobfuscatingRemapper.INSTANCE.getStaticFieldType(originalType, originalName, type, fieldName)) != null) {
                newDesc = this.remapper.mapDesc(replDesc);
            }
            if (this.mv != null) {
                this.mv.visitFieldInsn(opcode, type, fieldName, newDesc);
            }
        }
    }
}

