/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class DummyConfigElement
implements IConfigElement {
    protected boolean isProperty = true;
    protected boolean isList = false;
    protected ConfigGuiType type;
    protected String name;
    protected String langKey;
    protected Object value;
    protected Object defaultValue;
    protected Object[] values;
    protected Object[] defaultValues;
    protected String[] validValues;
    protected Pattern validStringPattern;
    protected Object minValue;
    protected Object maxValue;
    protected boolean requiresWorldRestart = false;
    protected boolean requiresMcRestart = false;
    protected boolean isListFixedLength = false;
    protected int maxListLength = -1;
    protected List<IConfigElement> childElements;
    protected Class<? extends GuiConfigEntries.IConfigEntry> configEntryClass;
    protected Class<? extends GuiEditArrayEntries.IArrayEntry> arrayEntryClass;

    public DummyConfigElement(String name, Object defaultValue, ConfigGuiType type, String langKey, String[] validValues, Pattern validStringPattern, Object minValue, Object maxValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.type = type;
        this.langKey = langKey;
        this.validValues = validValues;
        this.validStringPattern = validStringPattern;
        if (minValue == null) {
            if (type == ConfigGuiType.INTEGER) {
                this.minValue = Integer.MIN_VALUE;
            } else if (type == ConfigGuiType.DOUBLE) {
                this.minValue = -1.7976931348623157E308;
            }
        } else {
            this.minValue = minValue;
        }
        if (maxValue == null) {
            if (type == ConfigGuiType.INTEGER) {
                this.maxValue = Integer.MAX_VALUE;
            } else if (type == ConfigGuiType.DOUBLE) {
                this.maxValue = Double.MAX_VALUE;
            }
        } else {
            this.maxValue = maxValue;
        }
    }

    public DummyConfigElement(String name, Object defaultValue, ConfigGuiType type, String langKey, Pattern validStringPattern) {
        this(name, defaultValue, type, langKey, null, validStringPattern, null, null);
    }

    public DummyConfigElement(String name, Object defaultValue, ConfigGuiType type, String langKey, String[] validValues) {
        this(name, defaultValue, type, langKey, validValues, null, null, null);
    }

    public DummyConfigElement(String name, Object defaultValue, ConfigGuiType type, String langKey) {
        this(name, defaultValue, type, langKey, null, null, null, null);
    }

    public DummyConfigElement(String name, Object defaultValue, ConfigGuiType type, String langKey, Object minValue, Object maxValue) {
        this(name, defaultValue, type, langKey, null, null, minValue, maxValue);
    }

    public DummyConfigElement setCustomListEntryClass(Class<? extends GuiConfigEntries.IConfigEntry> clazz) {
        this.configEntryClass = clazz;
        return this;
    }

    @Override
    public boolean isProperty() {
        return this.isProperty;
    }

    public IConfigElement setConfigEntryClass(Class<? extends GuiConfigEntries.IConfigEntry> clazz) {
        this.configEntryClass = clazz;
        return this;
    }

    @Override
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.configEntryClass;
    }

    public IConfigElement setArrayEntryClass(Class<? extends GuiEditArrayEntries.IArrayEntry> clazz) {
        this.arrayEntryClass = clazz;
        return this;
    }

    @Override
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.arrayEntryClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public String getLanguageKey() {
        return this.langKey;
    }

    @Override
    public String getComment() {
        return bwl.a((String)(this.langKey + ".tooltip"), (Object[])new Object[0]);
    }

    @Override
    public List<IConfigElement> getChildElements() {
        return this.childElements;
    }

    @Override
    public ConfigGuiType getType() {
        return this.type;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isListLengthFixed() {
        return this.isListFixedLength;
    }

    @Override
    public int getMaxListLength() {
        return this.maxListLength;
    }

    @Override
    public boolean isDefault() {
        if (this.isProperty) {
            if (!this.isList) {
                if (this.value != null) {
                    return this.value.equals(this.defaultValue);
                }
                return this.defaultValue == null;
            }
            return Arrays.deepEquals(this.values, this.defaultValues);
        }
        return true;
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }

    @Override
    public Object[] getDefaults() {
        return this.defaultValues;
    }

    @Override
    public void setToDefault() {
        if (this.isList) {
            this.values = Arrays.copyOf(this.defaultValues, this.defaultValues.length);
        } else {
            this.value = this.defaultValue;
        }
    }

    public IConfigElement setRequiresWorldRestart(boolean requiresWorldRestart) {
        this.requiresWorldRestart = requiresWorldRestart;
        return this;
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.requiresWorldRestart;
    }

    @Override
    public boolean showInGui() {
        return true;
    }

    public IConfigElement setRequiresMcRestart(boolean requiresMcRestart) {
        this.requiresMcRestart = this.requiresWorldRestart = requiresMcRestart;
        return this;
    }

    @Override
    public boolean requiresMcRestart() {
        return this.requiresMcRestart;
    }

    @Override
    public String[] getValidValues() {
        return this.validValues;
    }

    @Override
    public Pattern getValidationPattern() {
        return this.validStringPattern;
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public Object[] getList() {
        return this.values;
    }

    @Override
    public void set(Object value) {
        this.defaultValue = value;
    }

    @Override
    public void set(Object[] aVal) {
        this.defaultValues = aVal;
    }

    @Override
    public Object getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getMaxValue() {
        return this.maxValue;
    }

    public static class DummyListElement
    extends DummyConfigElement {
        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, int maxListLength, Pattern validStringPattern, Object minValue, Object maxValue) {
            super(name, null, type, langKey, minValue, maxValue);
            this.defaultValues = defaultValues;
            this.values = defaultValues;
            this.isListFixedLength = isListFixedLength;
            this.maxListLength = maxListLength;
            this.validStringPattern = validStringPattern;
            this.isList = true;
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey) {
            this(name, defaultValues, type, langKey, false, -1, null, null, null);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, null, null, null);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, int maxListLength) {
            this(name, defaultValues, type, langKey, false, maxListLength, null, null, null);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, Object minValue, Object maxValue) {
            this(name, defaultValues, type, langKey, false, -1, null, minValue, maxValue);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, Object minValue, Object maxValue) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, null, minValue, maxValue);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, int maxListLength, Object minValue, Object maxValue) {
            this(name, defaultValues, type, langKey, false, maxListLength, null, minValue, maxValue);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, int maxListLength, Object minValue, Object maxValue) {
            this(name, defaultValues, type, langKey, isListFixedLength, maxListLength, null, minValue, maxValue);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, false, -1, validStringPattern, null, null);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, validStringPattern, null, null);
        }

        public DummyListElement(String name, Object[] defaultValues, ConfigGuiType type, String langKey, int maxListLength, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, false, maxListLength, validStringPattern, null, null);
        }

        public DummyListElement setCustomEditListEntryClass(Class<? extends GuiEditArrayEntries.IArrayEntry> clazz) {
            this.arrayEntryClass = clazz;
            return this;
        }

        @Override
        public Object getDefault() {
            return Arrays.toString(this.defaultValues);
        }
    }

    public static class DummyCategoryElement
    extends DummyConfigElement {
        public DummyCategoryElement(String name, String langKey, List<IConfigElement> childElements) {
            this(name, langKey, childElements, null);
        }

        public DummyCategoryElement(String name, String langKey, Class<? extends GuiConfigEntries.IConfigEntry> customListEntryClass) {
            this(name, langKey, new ArrayList<IConfigElement>(), customListEntryClass);
        }

        public DummyCategoryElement(String name, String langKey, List<IConfigElement> childElements, Class<? extends GuiConfigEntries.IConfigEntry> customListEntryClass) {
            super(name, null, ConfigGuiType.CONFIG_CATEGORY, langKey);
            this.childElements = childElements;
            this.configEntryClass = customListEntryClass;
            this.isProperty = false;
        }
    }
}

