/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundIngredient
extends AbstractIngredient {
    private final List<Ingredient> children;
    private List<Holder<Item>> items;
    private final boolean isSimple;
    public static final MapCodec<CompoundIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.listOf().fieldOf("children").forGetter(i -> i.children)).apply((Applicative)builder, CompoundIngredient::new));
    public static final IIngredientSerializer<CompoundIngredient> SERIALIZER = new IIngredientSerializer<CompoundIngredient>(){

        @Override
        public MapCodec<CompoundIngredient> codec() {
            return CODEC;
        }

        @Override
        public void write(RegistryFriendlyByteBuf buffer, CompoundIngredient value) {
            buffer.writeCollection(value.children, (buf, child) -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, child));
        }

        @Override
        public CompoundIngredient read(RegistryFriendlyByteBuf buffer) {
            ArrayList children = (ArrayList)buffer.readCollection(ArrayList::new, buf -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            return new CompoundIngredient(children);
        }
    };

    public static Ingredient of(Ingredient ... children) {
        if (children.length == 0) {
            throw new IllegalArgumentException("Cannot create a compound ingredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (children.length == 1) {
            return children[0];
        }
        return new CompoundIngredient(Arrays.asList(children));
    }

    private CompoundIngredient(List<Ingredient> children) {
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
    }

    @NotNull
    public List<Holder<Item>> items() {
        if (this.items == null) {
            ArrayList tmp = new ArrayList();
            for (Ingredient child : this.children) {
                tmp.addAll(child.items());
            }
            this.items = Collections.unmodifiableList(tmp);
        }
        return this.items;
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null) {
            return false;
        }
        for (Ingredient child : this.children) {
            if (!child.test(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

