/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.packets.ModVersions;
import org.jetbrains.annotations.ApiStatus;

public class NetworkContext {
    private static final String MARKER = "FORGE";
    public static final int NET_VERSION = 0;
    private static final AttributeKey<NetworkContext> CHANNEL_KEY = AttributeKey.valueOf((String)"forge:netcontext");
    private final Connection connection;
    private ConnectionType type = ConnectionType.VANILLA;
    private int netVersion = 0;
    @ApiStatus.Internal
    Set<ResourceLocation> remoteChannels = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> remoteChannelsView = Collections.unmodifiableSet(this.remoteChannels);
    @ApiStatus.Internal
    Set<ResourceLocation> sentChannels = new HashSet<ResourceLocation>();
    @ApiStatus.Internal
    Map<String, ModVersions.Info> modList = new HashMap<String, ModVersions.Info>();
    private Map<String, ModVersions.Info> modListView = Collections.unmodifiableMap(this.modList);
    @ApiStatus.Internal
    Map<ResourceLocation, Integer> channelList = new Object2IntOpenHashMap();
    @ApiStatus.Internal
    NetworkMismatchData mismatchData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkContext get(Connection connection) {
        Attribute attr = connection.channel().attr(CHANNEL_KEY);
        NetworkContext ret = (NetworkContext)attr.get();
        if (ret == null) {
            Channel channel = connection.channel();
            synchronized (channel) {
                ret = (NetworkContext)attr.get();
                if (ret == null) {
                    ret = new NetworkContext(connection);
                    attr.set((Object)ret);
                }
            }
        }
        return ret;
    }

    private NetworkContext(Connection connection) {
        this.connection = connection;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public int getNetVersion() {
        return this.netVersion;
    }

    public Set<ResourceLocation> getRemoteChannels() {
        return this.remoteChannelsView;
    }

    public Map<String, ModVersions.Info> getModList() {
        return this.modListView;
    }

    @ApiStatus.Internal
    public static String enhanceHostName(String hostName) {
        return String.join((CharSequence)"\u0000", hostName, MARKER);
    }

    @ApiStatus.Internal
    public void processIntention(String hostName) {
        this.type = ConnectionType.VANILLA;
        this.netVersion = 0;
        int idx = hostName.indexOf(0);
        if (idx != -1) {
            for (String pt : hostName.split("\u0000")) {
                if (!pt.startsWith(MARKER)) continue;
                this.type = ConnectionType.MODDED;
                if (pt.length() <= MARKER.length()) continue;
                this.netVersion = Integer.valueOf(pt.substring(MARKER.length()));
            }
        }
    }

    @ApiStatus.Internal
    public void finishTask(ConfigurationTask.Type task) {
        PacketListener packetListener = this.connection.getPacketListener();
        if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) {
            throw new IllegalStateException("Attempted to finish task " + String.valueOf(task) + " when packet listener was " + this.connection.getPacketListener().getClass().getName());
        }
        ServerConfigurationPacketListenerImpl cfg = (ServerConfigurationPacketListenerImpl)packetListener;
        cfg.finishCurrentTask(task);
    }

    @ApiStatus.Internal
    public NetworkMismatchData getMismatchs() {
        return this.mismatchData;
    }

    @ApiStatus.Internal
    void setConnectionType(ConnectionType type) {
        this.type = type;
    }

    @ApiStatus.Internal
    public record NetworkMismatchData(Map<ResourceLocation, Version> mismatched, Set<ResourceLocation> missing, boolean fromServer, Map<String, ModVersions.Info> mods) {

        public record Version(String received, String had) {
        }
    }
}

