/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

public interface PlayerEvent
extends LivingEvent {
    public Player getEntity();

    public static final class PlayerChangeGameModeEvent
    extends MutableEvent
    implements Cancellable,
    PlayerEvent {
        public static final CancellableEventBus<PlayerChangeGameModeEvent> BUS = CancellableEventBus.create(PlayerChangeGameModeEvent.class);
        private final Player player;
        private final GameType currentGameMode;
        private GameType newGameMode;

        public PlayerChangeGameModeEvent(Player player, GameType currentGameMode, GameType newGameMode) {
            this.player = player;
            this.currentGameMode = currentGameMode;
            this.newGameMode = newGameMode;
        }

        @Override
        public Player getEntity() {
            return this.player;
        }

        public GameType getCurrentGameMode() {
            return this.currentGameMode;
        }

        public GameType getNewGameMode() {
            return this.newGameMode;
        }

        public void setNewGameMode(GameType newGameMode) {
            this.newGameMode = newGameMode;
        }
    }

    public static final class PlayerChangedDimensionEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final ResourceKey<Level> getFrom;
        private final ResourceKey<Level> getTo;
        public static final EventBus<PlayerChangedDimensionEvent> BUS = EventBus.create(PlayerChangedDimensionEvent.class);

        public PlayerChangedDimensionEvent(Player getEntity, ResourceKey<Level> getFrom, ResourceKey<Level> getTo) {
            this.getEntity = getEntity;
            this.getFrom = getFrom;
            this.getTo = getTo;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerChangedDimensionEvent.class, "getEntity;getFrom;getTo", "getEntity", "getFrom", "getTo"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerChangedDimensionEvent.class, "getEntity;getFrom;getTo", "getEntity", "getFrom", "getTo"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerChangedDimensionEvent.class, "getEntity;getFrom;getTo", "getEntity", "getFrom", "getTo"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public ResourceKey<Level> getFrom() {
            return this.getFrom;
        }

        public ResourceKey<Level> getTo() {
            return this.getTo;
        }
    }

    public static final class PlayerRespawnEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final boolean isEndConquered;
        public static final EventBus<PlayerRespawnEvent> BUS = EventBus.create(PlayerRespawnEvent.class);

        public PlayerRespawnEvent(Player getEntity, boolean isEndConquered) {
            this.getEntity = getEntity;
            this.isEndConquered = isEndConquered;
        }

        public boolean isEndConquered() {
            return this.isEndConquered;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerRespawnEvent.class, "getEntity;isEndConquered", "getEntity", "isEndConquered"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerRespawnEvent.class, "getEntity;isEndConquered", "getEntity", "isEndConquered"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerRespawnEvent.class, "getEntity;isEndConquered", "getEntity", "isEndConquered"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }
    }

    public static final class PlayerLoggedOutEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        public static final EventBus<PlayerLoggedOutEvent> BUS = EventBus.create(PlayerLoggedOutEvent.class);

        public PlayerLoggedOutEvent(Player getEntity) {
            this.getEntity = getEntity;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerLoggedOutEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerLoggedOutEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerLoggedOutEvent.class, "getEntity", "getEntity"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }
    }

    public static final class PlayerLoggedInEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        public static final EventBus<PlayerLoggedInEvent> BUS = EventBus.create(PlayerLoggedInEvent.class);

        public PlayerLoggedInEvent(Player getEntity) {
            this.getEntity = getEntity;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerLoggedInEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerLoggedInEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerLoggedInEvent.class, "getEntity", "getEntity"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }
    }

    @NullMarked
    public static final class ItemSmeltedEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final ItemStack getSmelting;
        public static final EventBus<ItemSmeltedEvent> BUS = EventBus.create(ItemSmeltedEvent.class);

        public ItemSmeltedEvent(Player getEntity, ItemStack getSmelting) {
            this.getEntity = getEntity;
            this.getSmelting = getSmelting;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemSmeltedEvent.class, "getEntity;getSmelting", "getEntity", "getSmelting"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemSmeltedEvent.class, "getEntity;getSmelting", "getEntity", "getSmelting"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemSmeltedEvent.class, "getEntity;getSmelting", "getEntity", "getSmelting"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public ItemStack getSmelting() {
            return this.getSmelting;
        }
    }

    public static final class ItemCraftedEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        @NotNull
        private final ItemStack getCrafting;
        private final Container getContainer;
        public static final EventBus<ItemCraftedEvent> BUS = EventBus.create(ItemCraftedEvent.class);

        public ItemCraftedEvent(Player getEntity, @NotNull ItemStack getCrafting, Container getContainer) {
            this.getEntity = getEntity;
            this.getCrafting = getCrafting;
            this.getContainer = getContainer;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemCraftedEvent.class, "getEntity;getCrafting;getContainer", "getEntity", "getCrafting", "getContainer"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemCraftedEvent.class, "getEntity;getCrafting;getContainer", "getEntity", "getCrafting", "getContainer"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemCraftedEvent.class, "getEntity;getCrafting;getContainer", "getEntity", "getCrafting", "getContainer"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        @NotNull
        public ItemStack getCrafting() {
            return this.getCrafting;
        }

        public Container getContainer() {
            return this.getContainer;
        }
    }

    public static final class ItemPickupEvent
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final ItemEntity getOriginalEntity;
        private final ItemStack getStack;
        public static final EventBus<ItemPickupEvent> BUS = EventBus.create(ItemPickupEvent.class);

        public ItemPickupEvent(Player getEntity, ItemEntity getOriginalEntity, ItemStack getStack) {
            this.getEntity = getEntity;
            this.getOriginalEntity = getOriginalEntity;
            this.getStack = getStack;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemPickupEvent.class, "getEntity;getOriginalEntity;getStack", "getEntity", "getOriginalEntity", "getStack"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemPickupEvent.class, "getEntity;getOriginalEntity;getStack", "getEntity", "getOriginalEntity", "getStack"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemPickupEvent.class, "getEntity;getOriginalEntity;getStack", "getEntity", "getOriginalEntity", "getStack"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public ItemEntity getOriginalEntity() {
            return this.getOriginalEntity;
        }

        public ItemStack getStack() {
            return this.getStack;
        }
    }

    public static final class SaveToFile
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final File getPlayerDirectory;
        private final String getPlayerUUID;
        public static final EventBus<SaveToFile> BUS = EventBus.create(SaveToFile.class);

        public SaveToFile(Player getEntity, File getPlayerDirectory, String getPlayerUUID) {
            this.getEntity = getEntity;
            this.getPlayerDirectory = getPlayerDirectory;
            this.getPlayerUUID = getPlayerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.getPlayerDirectory;
        }

        public String getPlayerUUID() {
            return this.getPlayerUUID;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SaveToFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SaveToFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SaveToFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }
    }

    public static final class LoadFromFile
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final File getPlayerDirectory;
        private final String getPlayerUUID;
        public static final EventBus<LoadFromFile> BUS = EventBus.create(LoadFromFile.class);

        public LoadFromFile(Player getEntity, File getPlayerDirectory, String getPlayerUUID) {
            this.getEntity = getEntity;
            this.getPlayerDirectory = getPlayerDirectory;
            this.getPlayerUUID = getPlayerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.getPlayerDirectory;
        }

        public String getPlayerUUID() {
            return this.getPlayerUUID;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LoadFromFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LoadFromFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LoadFromFile.class, "getEntity;getPlayerDirectory;getPlayerUUID", "getEntity", "getPlayerDirectory", "getPlayerUUID"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }
    }

    public static final class StopTracking
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final Entity getTarget;
        public static final EventBus<StopTracking> BUS = EventBus.create(StopTracking.class);

        public StopTracking(Player getEntity, Entity getTarget) {
            this.getEntity = getEntity;
            this.getTarget = getTarget;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StopTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StopTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StopTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public Entity getTarget() {
            return this.getTarget;
        }
    }

    public static final class StartTracking
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final Entity getTarget;
        public static final EventBus<StartTracking> BUS = EventBus.create(StartTracking.class);

        public StartTracking(Player getEntity, Entity getTarget) {
            this.getEntity = getEntity;
            this.getTarget = getTarget;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StartTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StartTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StartTracking.class, "getEntity;getTarget", "getEntity", "getTarget"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public Entity getTarget() {
            return this.getTarget;
        }
    }

    public static final class Clone
    extends Record
    implements RecordEvent,
    PlayerEvent {
        private final Player getEntity;
        private final Player getOriginal;
        private final boolean isWasDeath;
        public static final EventBus<Clone> BUS = EventBus.create(Clone.class);

        public Clone(Player getEntity, Player getOriginal, boolean isWasDeath) {
            this.getEntity = getEntity;
            this.getOriginal = getOriginal;
            this.isWasDeath = isWasDeath;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Clone.class, "getEntity;getOriginal;isWasDeath", "getEntity", "getOriginal", "isWasDeath"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Clone.class, "getEntity;getOriginal;isWasDeath", "getEntity", "getOriginal", "isWasDeath"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Clone.class, "getEntity;getOriginal;isWasDeath", "getEntity", "getOriginal", "isWasDeath"}, this, o);
        }

        @Override
        public Player getEntity() {
            return this.getEntity;
        }

        public Player getOriginal() {
            return this.getOriginal;
        }

        public boolean isWasDeath() {
            return this.isWasDeath;
        }
    }

    public static final class TabListNameFormat
    extends MutableEvent
    implements PlayerEvent {
        public static final EventBus<TabListNameFormat> BUS = EventBus.create(TabListNameFormat.class);
        private final Player player;
        @Nullable
        private Component displayName;

        public TabListNameFormat(Player player) {
            this.player = player;
        }

        @Override
        public Player getEntity() {
            return this.player;
        }

        @Nullable
        public Component getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable Component displayName) {
            this.displayName = displayName;
        }
    }

    public static final class NameFormat
    extends MutableEvent
    implements PlayerEvent {
        public static final EventBus<NameFormat> BUS = EventBus.create(NameFormat.class);
        private final Player player;
        private final Component username;
        private Component displayname;

        public NameFormat(Player player, Component username) {
            this.player = player;
            this.username = username;
            this.setDisplayname(username);
        }

        @Override
        public Player getEntity() {
            return this.player;
        }

        public Component getUsername() {
            return this.username;
        }

        public Component getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(Component displayname) {
            this.displayname = displayname;
        }
    }

    public static final class BreakSpeed
    extends MutableEvent
    implements Cancellable,
    PlayerEvent {
        public static final CancellableEventBus<BreakSpeed> BUS = CancellableEventBus.create(BreakSpeed.class);
        private final Player player;
        private final BlockState state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final Optional<BlockPos> pos;

        public BreakSpeed(Player player, BlockState state, float original, @Nullable BlockPos pos) {
            this.player = player;
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = Optional.ofNullable(pos);
        }

        @Override
        public Player getEntity() {
            return this.player;
        }

        public BlockState getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public Optional<BlockPos> getPosition() {
            return this.pos;
        }
    }

    public static final class HarvestCheck
    extends MutableEvent
    implements PlayerEvent {
        public static final EventBus<HarvestCheck> BUS = EventBus.create(HarvestCheck.class);
        private final Player player;
        private final BlockState state;
        private boolean success;

        public HarvestCheck(Player player, BlockState state, boolean success) {
            this.player = player;
            this.state = state;
            this.success = success;
        }

        @Override
        public Player getEntity() {
            return this.player;
        }

        public BlockState getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

