/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.function.BooleanSupplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface TickEvent {

    public static sealed interface RenderTickEvent
    extends TickEvent {

        public record Post(DeltaTracker timer) implements RecordEvent,
        RenderTickEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(DeltaTracker timer) implements RecordEvent,
        RenderTickEvent
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);
        }
    }

    public static sealed interface PlayerTickEvent
    extends TickEvent {
        public LogicalSide side();

        public record Post(Player player, LogicalSide side) implements RecordEvent,
        PlayerTickEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            public Post(Player player) {
                this(player, player instanceof ServerPlayer ? LogicalSide.SERVER : LogicalSide.CLIENT);
            }
        }

        public record Pre(Player player, LogicalSide side) implements RecordEvent,
        PlayerTickEvent
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);

            public Pre(Player player) {
                this(player, player instanceof ServerPlayer ? LogicalSide.SERVER : LogicalSide.CLIENT);
            }
        }
    }

    public static sealed interface LevelTickEvent
    extends TickEvent {
        public LogicalSide side();

        public Level level();

        public BooleanSupplier haveTimeSupplier();

        default public boolean haveTime() {
            return this.haveTimeSupplier().getAsBoolean();
        }

        public record Post(LogicalSide side, Level level, BooleanSupplier haveTimeSupplier) implements RecordEvent,
        LevelTickEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(LogicalSide side, Level level, BooleanSupplier haveTimeSupplier) implements RecordEvent,
        LevelTickEvent
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);
        }
    }

    public static sealed interface ClientTickEvent
    extends TickEvent {

        public record Post() implements RecordEvent,
        ClientTickEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
            public static final Post INSTANCE = new Post();
        }

        public record Pre() implements RecordEvent,
        ClientTickEvent
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);
            public static final Pre INSTANCE = new Pre();
        }
    }

    public static sealed interface ServerTickEvent
    extends TickEvent {
        public BooleanSupplier haveTimeSupplier();

        default public boolean haveTime() {
            return this.haveTimeSupplier().getAsBoolean();
        }

        public MinecraftServer server();

        public record Post(BooleanSupplier haveTimeSupplier, MinecraftServer server) implements RecordEvent,
        ServerTickEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(BooleanSupplier haveTimeSupplier, MinecraftServer server) implements RecordEvent,
        ServerTickEvent
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);
        }
    }
}

