/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public sealed interface ScreenEvent {
    public @NonNull Screen getScreen();

    public record Closing(Screen getScreen) implements ScreenEvent,
    RecordEvent
    {
        public static final EventBus<Closing> BUS = EventBus.create(Closing.class);
    }

    public static final class Opening
    extends MutableEvent
    implements Cancellable,
    ScreenEvent {
        public static final CancellableEventBus<Opening> BUS = CancellableEventBus.create(Opening.class);
        private final Screen screen;
        @Nullable
        private final Screen currentScreen;
        private Screen newScreen;

        @ApiStatus.Internal
        public Opening(@Nullable Screen currentScreen, Screen screen) {
            this.screen = screen;
            this.currentScreen = currentScreen;
            this.newScreen = screen;
        }

        @Override
        public Screen getScreen() {
            return this.screen;
        }

        @Nullable
        public Screen getCurrentScreen() {
            return this.currentScreen;
        }

        @Nullable
        public Screen getNewScreen() {
            return this.newScreen;
        }

        public void setNewScreen(Screen newScreen) {
            this.newScreen = newScreen;
        }
    }

    public static sealed interface CharacterTyped
    extends ScreenEvent {
        public CharacterEvent getInfo();

        default public char getCodePoint() {
            return (char)this.getInfo().codepoint();
        }

        default public int getModifiers() {
            return this.getInfo().modifiers();
        }

        public record Post(Screen getScreen, CharacterEvent getInfo) implements CharacterTyped,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, CharacterEvent getInfo) implements Cancellable,
        CharacterTyped,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface KeyReleased
    extends KeyInput {

        public record Post(Screen getScreen, KeyEvent getInfo) implements Cancellable,
        KeyReleased,
        RecordEvent
        {
            public static final CancellableEventBus<Post> BUS = CancellableEventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, KeyEvent getInfo) implements Cancellable,
        KeyReleased,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface KeyPressed
    extends KeyInput {

        public record Post(Screen getScreen, KeyEvent getInfo) implements Cancellable,
        KeyPressed,
        RecordEvent
        {
            public static final CancellableEventBus<Post> BUS = CancellableEventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, KeyEvent getInfo) implements Cancellable,
        KeyPressed,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface KeyInput
    extends ScreenEvent
    permits KeyPressed, KeyReleased {
        public KeyEvent getInfo();

        default public int getKeyCode() {
            return this.getInfo().key();
        }

        default public int getScanCode() {
            return this.getInfo().scancode();
        }

        default public int getModifiers() {
            return this.getInfo().modifiers();
        }
    }

    public static sealed interface MouseScrolled
    extends MouseInput {
        public double getDeltaX();

        public double getDeltaY();

        public record Post(Screen getScreen, double getMouseX, double getMouseY, double getDeltaX, double getDeltaY) implements MouseScrolled,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, double getMouseX, double getMouseY, double getDeltaX, double getDeltaY) implements Cancellable,
        MouseScrolled,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface MouseDragged
    extends MouseInput {
        public int getMouseButton();

        public double getDragX();

        public double getDragY();

        public record Post(Screen getScreen, double getMouseX, double getMouseY, int getMouseButton, double getDragX, double getDragY) implements MouseDragged,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, double getMouseX, double getMouseY, int getMouseButton, double getDragX, double getDragY) implements Cancellable,
        MouseDragged,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface MouseButtonReleased
    extends MouseInput {
        public int getButton();

        public record Post(Screen getScreen, double getMouseX, double getMouseY, int getButton, boolean wasHandled, Result.Holder resultHolder) implements MouseButtonReleased,
        RecordEvent,
        HasResult.Record
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, double mouseX, double mouseY, int button, boolean handled) {
                this(screen, mouseX, mouseY, button, handled, new Result.Holder());
            }
        }

        public record Pre(Screen getScreen, double getMouseX, double getMouseY, int getButton) implements Cancellable,
        MouseButtonReleased,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface MouseButtonPressed
    extends MouseInput {
        public MouseButtonEvent getInfo();

        default public int getButton() {
            return this.getInfo().button();
        }

        public record Post(Screen getScreen, double getMouseX, double getMouseY, MouseButtonEvent getInfo, boolean wasHandled, Result.Holder resultHolder) implements HasResult.Record,
        MouseButtonPressed,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, double getMouseX, double getMouseY, MouseButtonEvent getInfo) implements Cancellable,
        MouseButtonPressed,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static sealed interface MouseInput
    extends ScreenEvent
    permits MouseButtonPressed, MouseButtonReleased, MouseDragged, MouseScrolled {
        public double getMouseX();

        public double getMouseY();
    }

    public static final class RenderInventoryMobEffects
    extends MutableEvent
    implements Cancellable,
    ScreenEvent {
        public static final CancellableEventBus<RenderInventoryMobEffects> BUS = CancellableEventBus.create(RenderInventoryMobEffects.class);
        private final Screen screen;
        private final int availableSpace;
        private boolean compact;
        private int horizontalOffset;

        @ApiStatus.Internal
        public RenderInventoryMobEffects(Screen screen, int availableSpace, boolean compact, int horizontalOffset) {
            this.screen = screen;
            this.availableSpace = availableSpace;
            this.compact = compact;
            this.horizontalOffset = horizontalOffset;
        }

        @Override
        public Screen getScreen() {
            return this.screen;
        }

        public int getAvailableSpace() {
            return this.availableSpace;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public void setHorizontalOffset(int offset) {
            this.horizontalOffset = offset;
        }

        public void addHorizontalOffset(int offset) {
            this.horizontalOffset += offset;
        }

        public void setCompact(boolean compact) {
            this.compact = compact;
        }
    }

    public record BackgroundRendered(Screen getScreen, GuiGraphics getGuiGraphics) implements RecordEvent,
    ScreenEvent
    {
        public static final EventBus<BackgroundRendered> BUS = EventBus.create(BackgroundRendered.class);
    }

    public static sealed interface Render
    extends ScreenEvent {
        public GuiGraphics getGuiGraphics();

        public int getMouseX();

        public int getMouseY();

        public float getPartialTick();

        public record Post(Screen getScreen, GuiGraphics getGuiGraphics, int getMouseX, int getMouseY, float getPartialTick) implements Render,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(Screen getScreen, GuiGraphics getGuiGraphics, int getMouseX, int getMouseY, float getPartialTick) implements Cancellable,
        Render,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }

    public static abstract sealed class Init
    extends MutableEvent
    implements ScreenEvent {
        private final Screen screen;
        private final Consumer<GuiEventListener> add;
        private final Consumer<GuiEventListener> remove;
        private final List<GuiEventListener> listenerList;

        @ApiStatus.Internal
        protected Init(Screen screen, List<GuiEventListener> listenerList, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
            this.screen = screen;
            this.listenerList = Collections.unmodifiableList(listenerList);
            this.add = add;
            this.remove = remove;
        }

        @Override
        public Screen getScreen() {
            return this.screen;
        }

        public List<GuiEventListener> getListenersList() {
            return this.listenerList;
        }

        public void addListener(GuiEventListener listener) {
            this.add.accept(listener);
        }

        public void removeListener(GuiEventListener listener) {
            this.remove.accept(listener);
        }

        public static final class Post
        extends Init {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }

        public static final class Pre
        extends Init
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }
    }
}

