/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;

public record CanToolPerformAction(ToolAction action) implements LootItemCondition
{
    public static final MapCodec<CanToolPerformAction> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ToolAction.CODEC.fieldOf("action").forGetter(CanToolPerformAction::action)).apply((Applicative)b, CanToolPerformAction::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.TOOL);
    }

    public boolean test(LootContext ctx) {
        ItemStack itemstack = (ItemStack)ctx.getParamOrNull(LootContextParams.TOOL);
        return itemstack != null && itemstack.canPerformAction(this.action);
    }

    public static LootItemCondition.Builder canToolPerformAction(ToolAction action) {
        return () -> new CanToolPerformAction(action);
    }
}

