/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

public interface ICondition {
    public static final Codec<ICondition> CODEC = Codec.lazyInitialized(() -> ForgeRegistries.CONDITION_SERIALIZERS.get().getCodec().dispatch(ICondition::codec, Function.identity()));
    public static final String DEFAULT_FIELD = "forge:condition";
    public static final MapCodec<Optional<ICondition>> OPTIONAL_FEILD_CODEC = CODEC.optionalFieldOf("forge:condition");
    public static final Codec<ICondition> SAFE_CODEC = CODEC.orElse((Object)FalseCondition.INSTANCE);

    public boolean test(IContext var1, DynamicOps<?> var2);

    public MapCodec<? extends ICondition> codec();

    public static interface IContext {
        @ApiStatus.Internal
        public static final ResourceLocation KEY = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"condition_context");
        public static final IContext EMPTY = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                return Collections.emptyMap();
            }
        };
        public static final IContext TAGS_INVALID = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                throw new UnsupportedOperationException("Usage of tag-based conditions is not permitted in this context!");
            }
        };

        default public <T> Collection<Holder<T>> getTag(TagKey<T> key) {
            return this.getAllTags(key.registry()).getOrDefault(key.location(), Set.of());
        }

        public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> var1);
    }
}

