/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.channel.Channel;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.ServerStatusPing;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class NetworkRegistry {
    static final Logger LOGGER = LogManager.getLogger();
    static final Marker NETREGISTRY = MarkerManager.getMarker((String)"NETREGISTRY");
    static Map<ResourceLocation, NetworkInstance> instances = Collections.synchronizedMap(new HashMap());
    static boolean lock = false;

    public static boolean acceptsVanillaClientConnections() {
        return (instances.isEmpty() || NetworkRegistry.listRejectedVanillaMods(n -> n.clientAcceptedVersions).isEmpty()) && DataPackRegistriesHooks.getSyncedCustomRegistries().isEmpty();
    }

    public static boolean canConnectToVanillaServer() {
        return instances.isEmpty() || NetworkRegistry.listRejectedVanillaMods(n -> n.serverAcceptedVersions).isEmpty();
    }

    @Nullable
    public static NetworkInstance findTarget(ResourceLocation resourceLocation) {
        return instances.get(resourceLocation);
    }

    static Map<ResourceLocation, ServerStatusPing.ChannelData> buildChannelVersionsForListPing() {
        return instances.entrySet().stream().filter(p -> !((ResourceLocation)p.getKey()).getNamespace().equals("forge")).collect(Collectors.toMap(e -> (ResourceLocation)e.getKey(), e -> ((NetworkInstance)e.getValue()).pingData));
    }

    static List<String> listRejectedVanillaMods(Function<NetworkInstance, Channel.VersionTest> testFunction) {
        ArrayList<String> results = new ArrayList<String>();
        for (NetworkInstance net : instances.values()) {
            boolean test = testFunction.apply(net).accepts(Channel.VersionTest.Status.VANILLA, -1);
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Vanilla acceptance test: {}", (Object)net.getChannelName(), (Object)(test ? "ACCEPTED" : "REJECTED"));
            if (test) continue;
            results.add(net.getChannelName().toString());
        }
        if (!results.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected vanilla connections", (Object)String.join((CharSequence)", ", results));
            return results;
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list from vanilla");
        return Collections.emptyList();
    }

    @Nullable
    public static NetworkContext.NetworkMismatchData validateChannels(Map<ResourceLocation, Integer> incoming, boolean fromClient) {
        String originName = fromClient ? "client" : "server";
        HashSet<ResourceLocation> missing = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, NetworkContext.NetworkMismatchData.Version> results = new HashMap<ResourceLocation, NetworkContext.NetworkMismatchData.Version>();
        instances.forEach((name, net) -> {
            Channel.VersionTest test = fromClient ? net.clientAcceptedVersions : net.serverAcceptedVersions;
            Channel.VersionTest.Status status = Channel.VersionTest.Status.MISSING;
            int version = 0;
            if (incoming.containsKey(net.getChannelName())) {
                status = Channel.VersionTest.Status.PRESENT;
                version = (Integer)incoming.get(net.getChannelName());
            }
            boolean accepted = test.accepts(status, version);
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Version test of '{} {}' from {} : {}", name, (Object)status, (Object)version, (Object)originName, (Object)(accepted ? "ACCEPTED" : "REJECTED"));
            if (!accepted) {
                if (status == Channel.VersionTest.Status.MISSING) {
                    missing.add((ResourceLocation)name);
                } else {
                    results.put((ResourceLocation)name, new NetworkContext.NetworkMismatchData.Version(Integer.toString(version), Integer.toString(net.getNetworkProtocolVersion())));
                }
            }
        });
        if (!results.isEmpty() || !missing.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected their {} side version number", (Object)Stream.concat(missing.stream(), results.keySet().stream()).map(Object::toString).collect(Collectors.joining(",")), (Object)originName);
            return new NetworkContext.NetworkMismatchData(results, missing, !fromClient, null);
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list from {}", (Object)originName);
        return null;
    }

    public static boolean checkListPingCompatibilityForClient(Map<ResourceLocation, ServerStatusPing.ChannelData> incoming) {
        HashSet<ResourceLocation> handled = new HashSet<ResourceLocation>();
        ArrayList<String> rejected = new ArrayList<String>();
        for (NetworkInstance net : instances.values()) {
            Channel.VersionTest.Status status = Channel.VersionTest.Status.MISSING;
            int version = 0;
            if (incoming.containsKey(net.getChannelName())) {
                status = Channel.VersionTest.Status.PRESENT;
                version = incoming.get(net.getChannelName()).version();
            }
            boolean accepted = net.serverAcceptedVersions.accepts(status, version);
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Version test of '{} {}' during listping : {}", (Object)net.getChannelName(), (Object)status, (Object)version, (Object)(accepted ? "ACCEPTED" : "REJECTED"));
            if (!accepted) {
                rejected.add(net.getChannelName().toString());
            }
            handled.add(net.getChannelName());
        }
        ArrayList missingButRequired = new ArrayList();
        incoming.forEach((name, data) -> {
            if (data.required() && !handled.contains(name)) {
                missingButRequired.add(name.toString());
            }
        });
        if (!rejected.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected their server side version number during listping", (Object)String.join((CharSequence)", ", rejected));
            return false;
        }
        if (!missingButRequired.isEmpty()) {
            LOGGER.error(NETREGISTRY, "The server is likely to require channel [{}] to be present, yet we don't have it", (Object)String.join((CharSequence)", ", missingButRequired));
            return false;
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list during listping");
        return true;
    }

    public static void lock() {
        lock = true;
    }

    public static void onConnectionStart(Connection connection) {
        ForgeEventFactory.onConnectionStart(connection);
        Channel channel = connection.channel();
        for (NetworkInstance inst : instances.values()) {
            if (inst.attributes != null) {
                inst.attributes.forEach((k, v) -> channel.attr(k).compareAndSet(null, v.apply(connection)));
            }
            if (inst.channelHandler == null) continue;
            inst.channelHandler.accept(connection);
        }
    }

    public static Map<ResourceLocation, Integer> buildChannelVersions() {
        Object2IntOpenHashMap ret = new Object2IntOpenHashMap(instances.size());
        instances.forEach((k, v) -> ret.put(k, v.getNetworkProtocolVersion()));
        return ret;
    }
}

