/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.function.Consumer;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ICustomPacket;

public class NetworkProtocol<B extends FriendlyByteBuf> {
    public static final NetworkProtocol<RegistryFriendlyByteBuf> PLAY = new NetworkProtocol(ConnectionProtocol.PLAY);
    public static final NetworkProtocol<FriendlyByteBuf> LOGIN = new NetworkProtocol(ConnectionProtocol.LOGIN);
    public static final NetworkProtocol<FriendlyByteBuf> CONFIGURATION = new NetworkProtocol(ConnectionProtocol.CONFIGURATION);
    private final ConnectionProtocol protocol;

    private NetworkProtocol(ConnectionProtocol protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return this.protocol.name();
    }

    public ConnectionProtocol toVanilla() {
        return this.protocol;
    }

    public <T extends Packet<?>, MSG> ICustomPacket<T> buildPacket(PacketFlow direction, Channel<MSG> channel, MSG packet) {
        ResourceLocation name = channel.getName();
        Consumer<FriendlyByteBuf> encoder = buf -> channel.encode((FriendlyByteBuf)buf, packet);
        switch (this.protocol) {
            case PLAY: 
            case CONFIGURATION: {
                if (direction == PacketFlow.CLIENTBOUND) {
                    return new ClientboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(name, null, encoder));
                }
                return new ServerboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(name, null, encoder));
            }
            case LOGIN: {
                if (direction == PacketFlow.CLIENTBOUND) {
                    return new ClientboundCustomQueryPacket(0, (CustomQueryPayload)new DiscardedQueryPayload(name, null, encoder));
                }
                return new ServerboundCustomQueryAnswerPacket(0, (CustomQueryAnswerPayload)new DiscardedQueryAnswerPayload(null, encoder));
            }
        }
        throw new IllegalArgumentException("Invalid protocol, shouldn't be possible as this is a private class..");
    }
}

