/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.Objects;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.NetworkProtocol;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.packets.LoginWrapper;

public abstract class Channel<MSG> {
    protected final NetworkInstance instance;

    protected Channel(NetworkInstance instance) {
        this.instance = instance;
    }

    public ResourceLocation getName() {
        return this.instance.getChannelName();
    }

    public int getProtocolVersion() {
        return this.instance.getNetworkProtocolVersion();
    }

    public boolean isRemotePresent(Connection connection) {
        return NetworkContext.get(connection).getRemoteChannels().contains(this.getName());
    }

    public abstract void encode(FriendlyByteBuf var1, MSG var2);

    protected Packet<?> toVanillaPacket(Connection connection, MSG message) {
        ConnectionProtocol protocol = connection.getProtocol();
        NetworkProtocol<FriendlyByteBuf> handler = switch (protocol) {
            case ConnectionProtocol.LOGIN -> NetworkProtocol.LOGIN;
            case ConnectionProtocol.CONFIGURATION -> NetworkProtocol.CONFIGURATION;
            case ConnectionProtocol.PLAY -> NetworkProtocol.PLAY;
            default -> throw new IllegalStateException("Unsupported protocol " + protocol.name() + " in Forge Networking Channel");
        };
        if (protocol == ConnectionProtocol.LOGIN && this != NetworkInitialization.LOGIN && connection.getSending() == PacketFlow.SERVERBOUND) {
            return NetworkInitialization.LOGIN.toVanillaPacket(connection, new LoginWrapper(this, message));
        }
        return handler.buildPacket(connection.getSending(), this, message).getThis();
    }

    public void send(MSG msg, Connection connection) {
        connection.send(this.toVanillaPacket(connection, msg));
    }

    public void send(MSG msg, PacketDistributor.PacketTarget target) {
        target.send((Packet<?>)target.direction().buildPacket(this, msg).getThis());
    }

    public void reply(MSG msg, CustomPayloadEvent.Context context) {
        this.send(msg, context.getConnection());
    }

    @FunctionalInterface
    public static interface VersionTest {
        public static final VersionTest ACCEPT_MISSING = (status, version) -> status == Status.MISSING;
        public static final VersionTest ACCEPT_VANILLA = (status, version) -> status == Status.VANILLA;

        public static VersionTest exact(int version) {
            return (status, remoteVersion) -> status == Status.PRESENT && version == remoteVersion;
        }

        public boolean accepts(Status var1, int var2);

        default public VersionTest negate() {
            return (status, version) -> !this.accepts(status, version);
        }

        default public VersionTest and(VersionTest other) {
            Objects.requireNonNull(other);
            return (status, version) -> this.accepts(status, version) && other.accepts(status, version);
        }

        default public VersionTest or(VersionTest other) {
            Objects.requireNonNull(other);
            return (status, version) -> this.accepts(status, version) || other.accepts(status, version);
        }

        public static enum Status {
            VANILLA,
            MISSING,
            PRESENT;

        }
    }
}

