/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraftforge.common.util.HexDumper;
import net.minecraftforge.network.ICustomPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketLogger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"PACKETLOG");
    private final Connection connection;
    public boolean enabled = false;

    public PacketLogger(Connection connection) {
        this.connection = connection;
    }

    public void send(Packet<?> packet) {
        this.common(this.connection.getReceiving(), this.connection.getSending(), packet);
    }

    public void recv(Packet<?> packet) {
        this.common(this.connection.getReceiving(), this.connection.getReceiving(), packet);
    }

    private void common(PacketFlow side, PacketFlow flow, Packet<?> packet) {
        ICustomPacket custom;
        if (!this.enabled) {
            return;
        }
        if (packet instanceof ClientboundFinishConfigurationPacket) {
            this.enabled = false;
        }
        if (packet instanceof ICustomPacket && (custom = (ICustomPacket)packet).getInternalData() != null) {
            LOGGER.info(MARKER, "{} {} {} {}\n{}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName(), (Object)custom.getName(), (Object)HexDumper.dump((ByteBuf)custom.getInternalData()));
        } else {
            LOGGER.info(MARKER, "{} {} {}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName());
        }
    }

    private static String side(PacketFlow side) {
        return side == PacketFlow.CLIENTBOUND ? "CLIENT" : "SERVER";
    }

    private static String dir(PacketFlow flow) {
        return flow == PacketFlow.CLIENTBOUND ? "S->C" : "C->S";
    }
}

