/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public interface IForgeFluid {
    default public float getExplosionResistance(FluidState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return state.getExplosionResistance();
    }

    public FluidType getFluidType();

    default public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        return this.getFluidType().move(state, entity, movementVector, gravity);
    }

    default public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return this.getFluidType().canConvertToSource(state, (LevelReader)level, pos);
    }

    default public boolean supportsBoating(FluidState state, Boat boat) {
        return this.getFluidType().supportsBoating(state, boat);
    }

    default public boolean shouldUpdateWhileBoating(FluidState state, Boat boat, Entity rider) {
        return this.getFluidType().shouldUpdateWhileBoating(state, boat, rider);
    }

    @Nullable
    default public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
        return this.getFluidType().getBlockPathType(state, level, pos, mob, canFluidLog);
    }

    @Nullable
    default public PathType getAdjacentBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return this.getFluidType().getAdjacentBlockPathType(state, level, pos, mob, originalType);
    }

    default public boolean canHydrate(FluidState state, BlockGetter getter, BlockPos pos, BlockState source, BlockPos sourcePos) {
        return this.getFluidType().canHydrate(state, getter, pos, source, sourcePos);
    }

    default public boolean canExtinguish(FluidState state, BlockGetter getter, BlockPos pos) {
        return this.getFluidType().canExtinguish(state, getter, pos);
    }
}

