/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import net.minecraftforge.fml.loading.AdvancedLogMessageAdapter;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.registries.ClearableRegistry;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.NamespacedDefaultedWrapper;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameData {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation BLOCKS = new ResourceLocation("block");
    public static final ResourceLocation FLUIDS = new ResourceLocation("fluid");
    public static final ResourceLocation ITEMS = new ResourceLocation("item");
    public static final ResourceLocation POTIONS = new ResourceLocation("mob_effect");
    public static final ResourceLocation BIOMES = new ResourceLocation("biome");
    public static final ResourceLocation SOUNDEVENTS = new ResourceLocation("sound_event");
    public static final ResourceLocation POTIONTYPES = new ResourceLocation("potion");
    public static final ResourceLocation ENCHANTMENTS = new ResourceLocation("enchantment");
    public static final ResourceLocation ENTITIES = new ResourceLocation("entity_type");
    public static final ResourceLocation TILEENTITIES = new ResourceLocation("block_entity_type");
    public static final ResourceLocation PARTICLE_TYPES = new ResourceLocation("particle_type");
    public static final ResourceLocation CONTAINERS = new ResourceLocation("menu");
    public static final ResourceLocation PAINTING_TYPES = new ResourceLocation("motive");
    public static final ResourceLocation RECIPE_SERIALIZERS = new ResourceLocation("recipe_serializer");
    public static final ResourceLocation STAT_TYPES = new ResourceLocation("stat_type");
    public static final ResourceLocation PROFESSIONS = new ResourceLocation("villager_profession");
    public static final ResourceLocation POI_TYPES = new ResourceLocation("point_of_interest_type");
    public static final ResourceLocation MEMORY_MODULE_TYPES = new ResourceLocation("memory_module_type");
    public static final ResourceLocation SENSOR_TYPES = new ResourceLocation("sensor_type");
    public static final ResourceLocation SCHEDULES = new ResourceLocation("schedule");
    public static final ResourceLocation ACTIVITIES = new ResourceLocation("activities");
    public static final ResourceLocation WORLD_CARVERS = new ResourceLocation("carver");
    public static final ResourceLocation SURFACE_BUILDERS = new ResourceLocation("surface_builder");
    public static final ResourceLocation FEATURES = new ResourceLocation("feature");
    public static final ResourceLocation DECORATORS = new ResourceLocation("decorator");
    public static final ResourceLocation BIOME_PROVIDER_TYPES = new ResourceLocation("biome_source_type");
    public static final ResourceLocation CHUNK_GENERATOR_TYPES = new ResourceLocation("chunk_generator_type");
    public static final ResourceLocation CHUNK_STATUS = new ResourceLocation("chunk_status");
    public static final ResourceLocation BLOCK_STATE_PROVIDER_TYPES = new ResourceLocation("block_state_provider_type");
    public static final ResourceLocation BLOCK_PLACER_TYPES = new ResourceLocation("block_placer_type");
    public static final ResourceLocation FOLIAGE_PLACER_TYPES = new ResourceLocation("foliage_placer_type");
    public static final ResourceLocation TREE_DECORATOR_TYPES = new ResourceLocation("tree_decorator_type");
    public static final ResourceLocation MODDIMENSIONS = new ResourceLocation("forge:moddimensions");
    public static final ResourceLocation SERIALIZERS = new ResourceLocation("minecraft:dataserializers");
    public static final ResourceLocation LOOT_MODIFIER_SERIALIZERS = new ResourceLocation("forge:loot_modifier_serializers");
    private static final int MAX_VARINT = 0x7FFFFFFE;
    private static final ResourceLocation BLOCK_TO_ITEM = new ResourceLocation("minecraft:blocktoitemmap");
    private static final ResourceLocation BLOCKSTATE_TO_ID = new ResourceLocation("minecraft:blockstatetoid");
    private static final ResourceLocation SERIALIZER_TO_ENTRY = new ResourceLocation("forge:serializer_to_entry");
    private static final ResourceLocation STRUCTURE_FEATURES = new ResourceLocation("minecraft:structure_feature");
    private static final ResourceLocation STRUCTURES = new ResourceLocation("minecraft:structures");
    private static boolean hasInit = false;
    private static final boolean DISABLE_VANILLA_REGISTRIES = Boolean.parseBoolean(System.getProperty("forge.disableVanillaGameData", "false"));
    private static final BiConsumer<ResourceLocation, ForgeRegistry<?>> LOCK_VANILLA = (name, reg) -> reg.slaves.values().stream().filter(o -> o instanceof ILockableRegistry).forEach(o -> ((ILockableRegistry)o).lock());
    private static Field regName;

    public static void init() {
        if (DISABLE_VANILLA_REGISTRIES) {
            LOGGER.warn(ForgeRegistry.REGISTRIES, "DISABLING VANILLA REGISTRY CREATION AS PER SYSTEM VARIABLE SETTING! forge.disableVanillaGameData");
            return;
        }
        if (hasInit) {
            return;
        }
        hasInit = true;
        GameData.makeRegistry(BLOCKS, Block.class, new ResourceLocation("air")).addCallback(BlockCallbacks.INSTANCE).legacyName("blocks").create();
        GameData.makeRegistry(FLUIDS, Fluid.class, new ResourceLocation("empty")).create();
        GameData.makeRegistry(ITEMS, Item.class, new ResourceLocation("air")).addCallback(ItemCallbacks.INSTANCE).legacyName("items").create();
        GameData.makeRegistry(POTIONS, Effect.class).legacyName("potions").create();
        GameData.makeRegistry(BIOMES, Biome.class).legacyName("biomes").create();
        GameData.makeRegistry(SOUNDEVENTS, SoundEvent.class).legacyName("soundevents").create();
        GameData.makeRegistry(POTIONTYPES, Potion.class, new ResourceLocation("empty")).legacyName("potiontypes").create();
        GameData.makeRegistry(ENCHANTMENTS, Enchantment.class).legacyName("enchantments").create();
        GameData.makeRegistry(ENTITIES, EntityType.class, new ResourceLocation("pig")).legacyName("entities").create();
        GameData.makeRegistry(TILEENTITIES, TileEntityType.class).disableSaving().legacyName("tileentities").create();
        GameData.makeRegistry(PARTICLE_TYPES, ParticleType.class).disableSaving().create();
        GameData.makeRegistry(CONTAINERS, ContainerType.class).disableSaving().create();
        GameData.makeRegistry(PAINTING_TYPES, PaintingType.class, new ResourceLocation("kebab")).create();
        GameData.makeRegistry(RECIPE_SERIALIZERS, IRecipeSerializer.class).disableSaving().create();
        GameData.makeRegistry(STAT_TYPES, StatType.class).create();
        GameData.makeRegistry(PROFESSIONS, VillagerProfession.class, new ResourceLocation("none")).create();
        GameData.makeRegistry(POI_TYPES, PointOfInterestType.class, new ResourceLocation("unemployed")).disableSync().create();
        GameData.makeRegistry(MEMORY_MODULE_TYPES, MemoryModuleType.class, new ResourceLocation("dummy")).disableSync().create();
        GameData.makeRegistry(SENSOR_TYPES, SensorType.class, new ResourceLocation("dummy")).disableSaving().disableSync().create();
        GameData.makeRegistry(SCHEDULES, Schedule.class).disableSaving().disableSync().create();
        GameData.makeRegistry(ACTIVITIES, Activity.class).disableSaving().disableSync().create();
        GameData.makeRegistry(WORLD_CARVERS, WorldCarver.class).disableSaving().disableSync().create();
        GameData.makeRegistry(SURFACE_BUILDERS, SurfaceBuilder.class).disableSaving().disableSync().create();
        GameData.makeRegistry(FEATURES, Feature.class).addCallback(FeatureCallbacks.INSTANCE).disableSaving().create();
        GameData.makeRegistry(DECORATORS, Placement.class).disableSaving().disableSync().create();
        GameData.makeRegistry(BIOME_PROVIDER_TYPES, BiomeProviderType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(CHUNK_GENERATOR_TYPES, ChunkGeneratorType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(CHUNK_STATUS, ChunkStatus.class, new ResourceLocation("empty")).disableSaving().disableSync().create();
        GameData.makeRegistry(BLOCK_STATE_PROVIDER_TYPES, BlockStateProviderType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(BLOCK_PLACER_TYPES, BlockPlacerType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(FOLIAGE_PLACER_TYPES, FoliagePlacerType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(TREE_DECORATOR_TYPES, TreeDecoratorType.class).disableSaving().disableSync().create();
        GameData.makeRegistry(MODDIMENSIONS, ModDimension.class).disableSaving().create();
        GameData.makeRegistry(SERIALIZERS, DataSerializerEntry.class, 256, 0x7FFFFFFE).disableSaving().disableOverrides().addCallback(SerializerCallbacks.INSTANCE).create();
        GameData.makeRegistry(LOOT_MODIFIER_SERIALIZERS, GlobalLootModifierSerializer.class).disableSaving().disableSync().create();
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(0x7FFFFFFE).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, int min, int max) {
        return new RegistryBuilder().setName(name).setType(type).setIDRange(min, max).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, ResourceLocation _default) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(0x7FFFFFFE).addCallback(new NamespacedDefaultedWrapper.Factory()).setDefaultKey(_default);
    }

    public static <V extends IForgeRegistryEntry<V>> DefaultedRegistry<V> getWrapperDefaulted(Class<? super V> cls) {
        IForgeRegistry<V> reg = RegistryManager.ACTIVE.getRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        DefaultedRegistry ret = reg.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static <V extends IForgeRegistryEntry<V>> SimpleRegistry<V> getWrapper(Class<? super V> cls) {
        IForgeRegistry<V> reg = RegistryManager.ACTIVE.getRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        SimpleRegistry ret = reg.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static Map<Block, Item> getBlockItemMap() {
        return RegistryManager.ACTIVE.getRegistry(Item.class).getSlaveMap(BLOCK_TO_ITEM, Map.class);
    }

    public static ObjectIntIdentityMap<BlockState> getBlockStateIDMap() {
        return RegistryManager.ACTIVE.getRegistry(Block.class).getSlaveMap(BLOCKSTATE_TO_ID, ObjectIntIdentityMap.class);
    }

    public static Map<IDataSerializer<?>, DataSerializerEntry> getSerializerMap() {
        return RegistryManager.ACTIVE.getRegistry(DataSerializerEntry.class).getSlaveMap(SERIALIZER_TO_ENTRY, Map.class);
    }

    public static Registry<Structure<?>> getStructureFeatures() {
        return RegistryManager.ACTIVE.getRegistry(Feature.class).getSlaveMap(STRUCTURE_FEATURES, Registry.class);
    }

    public static BiMap<String, Structure<?>> getStructureMap() {
        return RegistryManager.ACTIVE.getRegistry(Feature.class).getSlaveMap(STRUCTURES, BiMap.class);
    }

    public static <K extends IForgeRegistryEntry<K>> K register_impl(K value) {
        Validate.notNull(value, (String)"Attempted to register a null object", (Object[])new Object[0]);
        Validate.notNull((Object)value.getRegistryName(), (String)String.format("Attempt to register object without having set a registry name %s (type %s)", value, value.getClass().getName()), (Object[])new Object[0]);
        IForgeRegistry<K> registry = RegistryManager.ACTIVE.getRegistry(value.getRegistryType());
        Validate.notNull(registry, (String)("Attempted to registry object without creating registry first: " + value.getRegistryType().getName()), (Object[])new Object[0]);
        registry.register(value);
        return value;
    }

    public static void vanillaSnapshot() {
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Creating vanilla freeze snapshot");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.ACTIVE, RegistryManager.VANILLA, clazz, true);
        }
        RegistryManager.VANILLA.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.VANILLA.registries.forEach(LOCK_VANILLA);
        RegistryManager.ACTIVE.registries.forEach(LOCK_VANILLA);
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Vanilla freeze snapshot created");
    }

    public static void freezeData() {
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Freezing registries");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.ACTIVE, RegistryManager.FROZEN, clazz, true);
        }
        RegistryManager.FROZEN.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.freeze();
            reg.bake();
            reg.dump((ResourceLocation)name);
        });
        GameData.fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, Integer[]>>)ImmutableMap.of(), true);
        LOGGER.debug(ForgeRegistry.REGISTRIES, "All registries frozen");
    }

    public static void revertToFrozen() {
        if (RegistryManager.FROZEN.registries.isEmpty()) {
            LOGGER.warn(ForgeRegistry.REGISTRIES, "Can't revert to frozen GameData state without freezing first.");
            return;
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Reverting to frozen data state.");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.FROZEN, RegistryManager.ACTIVE, clazz, true);
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.bake());
        GameData.fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, Integer[]>>)ImmutableMap.of(), true);
        ObjectHolderRegistry.applyObjectHolders();
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Frozen state restored.");
    }

    public static void revert(RegistryManager state, ResourceLocation registry, boolean lock) {
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Reverting {} to {}", (Object)registry, (Object)state.getName());
        Class clazz = RegistryManager.ACTIVE.getSuperType(registry);
        GameData.loadRegistry(registry, state, RegistryManager.ACTIVE, clazz, lock);
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Reverting complete");
    }

    private static <T extends IForgeRegistryEntry<T>> void loadRegistry(final ResourceLocation registryName, final RegistryManager from, final RegistryManager to, Class<T> regType, boolean freeze) {
        ForgeRegistry fromRegistry = from.getRegistry(registryName);
        if (fromRegistry == null) {
            ForgeRegistry toRegistry = to.getRegistry(registryName);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (ResourceLocation name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (ResourceLocation name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
        } else {
            ForgeRegistry toRegistry = to.getRegistry(registryName, from);
            toRegistry.sync(registryName, fromRegistry);
            if (freeze) {
                toRegistry.isFrozen = true;
            }
        }
    }

    public static Multimap<ResourceLocation, ResourceLocation> injectSnapshot(Map<ResourceLocation, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        List missingRegs;
        LOGGER.info(ForgeRegistry.REGISTRIES, "Injecting existing registry data into this {} instance", (Object)EffectiveSide.get());
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        snapshot = snapshot.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(e -> RegistryManager.ACTIVE.updateLegacyName((ResourceLocation)e.getKey()), Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
        if (isLocalWorld && (missingRegs = snapshot.keySet().stream().filter(name -> !RegistryManager.ACTIVE.registries.containsKey(name)).collect(Collectors.toList())).size() > 0) {
            String header = "Forge Mod Loader detected missing/unknown registrie(s).\n\nThere are " + missingRegs.size() + " missing registries in this save.\nIf you continue the missing registries will get removed.\nThis may cause issues, it is advised that you create a world backup before continuing.\n\n";
            StringBuilder text = new StringBuilder("Missing Registries:\n");
            for (ResourceLocation s : missingRegs) {
                text.append(s).append("\n");
            }
            boolean confirmed = StartupQuery.builder().header(header).text(text.toString()).action("Continue anyway?").confirm();
            if (!confirmed) {
                StartupQuery.abort();
            }
        }
        RegistryManager STAGING = new RegistryManager("STAGING");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        snapshot.forEach((key, value) -> {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)key);
            remaps.put(key, Maps.newLinkedHashMap());
            missing.put(key, Maps.newHashMap());
            GameData.loadPersistentDataToStagingRegistry(RegistryManager.ACTIVE, STAGING, (Map)remaps.get(key), (Map)missing.get(key), key, value, clazz);
        });
        snapshot.forEach((key, value) -> value.dummied.forEach(dummy -> {
            Map m = (Map)missing.get(key);
            ForgeRegistry reg = STAGING.getRegistry((ResourceLocation)key);
            if (m.containsKey(dummy)) {
                if (reg.markDummy((ResourceLocation)dummy, (Integer)m.get(dummy))) {
                    m.remove(dummy);
                }
            } else if (isLocalWorld) {
                LOGGER.debug(ForgeRegistry.REGISTRIES, "Registry {}: Resuscitating dummy entry {}", key, dummy);
            } else {
                int id = reg.getID((ResourceLocation)dummy);
                LOGGER.warn(ForgeRegistry.REGISTRIES, "Registry {}: The ID {} @ {} is currently locally mapped - it will be replaced with a dummy for this session", dummy, key, (Object)id);
                reg.markDummy((ResourceLocation)dummy, id);
            }
        }));
        int count = missing.values().stream().mapToInt(Map::size).sum();
        if (count > 0) {
            LOGGER.debug(ForgeRegistry.REGISTRIES, "There are {} mappings missing - attempting a mod remap", (Object)count);
            ArrayListMultimap defaulted = ArrayListMultimap.create();
            ArrayListMultimap failed = ArrayListMultimap.create();
            missing.entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 0).forEach(arg_0 -> GameData.lambda$injectSnapshot$25(STAGING, (Multimap)failed, remaps, (Multimap)defaulted, isLocalWorld, arg_0));
            if (!defaulted.isEmpty() && !isLocalWorld) {
                return defaulted;
            }
            if (!defaulted.isEmpty()) {
                String header = "Forge Mod Loader detected missing registry entries.\n\nThere are " + defaulted.size() + " missing entries in this save.\nIf you continue the missing entries will get removed.\nA world backup will be automatically created in your saves directory.\n\n";
                StringBuilder buf = new StringBuilder();
                defaulted.asMap().forEach((name, entries) -> {
                    buf.append("Missing ").append(name).append(":\n");
                    entries.forEach(rl -> buf.append("    ").append(rl).append("\n"));
                    buf.append("\n");
                });
                boolean confirmed = StartupQuery.builder().header(header).text(buf.toString()).action("Remove entries and continue?").confirm();
                if (!confirmed) {
                    StartupQuery.abort();
                }
            }
            if (!defaulted.isEmpty() && isLocalWorld) {
                LOGGER.error(ForgeRegistry.REGISTRIES, "There are unidentified mappings in this world - we are going to attempt to process anyway");
            }
        }
        if (injectFrozenData) {
            missing.forEach((name, m) -> {
                ForgeRegistry reg = STAGING.getRegistry((ResourceLocation)name);
                m.forEach((rl, id) -> reg.markDummy((ResourceLocation)rl, (int)id));
            });
            RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
                Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)name);
                GameData.loadFrozenDataToStagingRegistry(STAGING, name, (Map)remaps.get(name), clazz);
            });
        }
        STAGING.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((key, value) -> {
            Class registrySuperType = RegistryManager.ACTIVE.getSuperType((ResourceLocation)key);
            GameData.loadRegistry(key, STAGING, RegistryManager.ACTIVE, registrySuperType, true);
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.bake();
            reg.dump((ResourceLocation)name);
        });
        GameData.fireRemapEvent(remaps, false);
        ObjectHolderRegistry.applyObjectHolders();
        return ArrayListMultimap.create();
    }

    private static void fireRemapEvent(Map<ResourceLocation, Map<ResourceLocation, Integer[]>> remaps, boolean isFreezing) {
        StartupMessageManager.modLoaderConsumer().ifPresent(s -> s.accept("Remapping mod data"));
        MinecraftForge.EVENT_BUS.post((Event)new FMLModIdMappingEvent(remaps, isFreezing));
        StartupMessageManager.modLoaderConsumer().ifPresent(s -> s.accept("Remap complete"));
    }

    private static <T extends IForgeRegistryEntry<T>> void loadPersistentDataToStagingRegistry(RegistryManager pool, RegistryManager to, Map<ResourceLocation, Integer[]> remaps, Map<ResourceLocation, Integer> missing, ResourceLocation name, ForgeRegistry.Snapshot snap, Class<T> regType) {
        ForgeRegistry active = pool.getRegistry(name);
        if (active == null) {
            return;
        }
        ForgeRegistry _new = to.getRegistry(name, RegistryManager.ACTIVE);
        snap.aliases.forEach(_new::addAlias);
        snap.blocked.forEach(_new::block);
        snap.dummied.forEach(_new::addDummy);
        _new.loadIds(snap.ids, snap.overrides, missing, remaps, active, name);
    }

    private static <T extends IForgeRegistryEntry<T>> void processMissing(Class<T> clazz, ResourceLocation name, RegistryManager STAGING, RegistryEvent.MissingMappings<?> e, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies) {
        ImmutableList<RegistryEvent.MissingMappings.Mapping<?>> mappings = e.getAllMappings();
        ForgeRegistry active = RegistryManager.ACTIVE.getRegistry(name);
        ForgeRegistry staging = STAGING.getRegistry(name);
        staging.processMissingEvent(name, active, mappings, missing, remaps, defaulted, failed, injectNetworkDummies);
    }

    private static <T extends IForgeRegistryEntry<T>> void loadFrozenDataToStagingRegistry(RegistryManager STAGING, ResourceLocation name, Map<ResourceLocation, Integer[]> remaps, Class<T> clazz) {
        ForgeRegistry frozen = RegistryManager.FROZEN.getRegistry(name);
        ForgeRegistry newRegistry = STAGING.getRegistry(name, RegistryManager.FROZEN);
        HashMap _new = Maps.newHashMap();
        frozen.getKeys().stream().filter(key -> !newRegistry.containsKey((ResourceLocation)key)).forEach(key -> _new.put(key, frozen.getID((ResourceLocation)key)));
        newRegistry.loadIds(_new, frozen.getOverrideOwners(), Maps.newLinkedHashMap(), remaps, frozen, name);
    }

    public static void fireCreateRegistryEvents() {
        MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.NewRegistry());
    }

    public static void fireCreateRegistryEvents(LifecycleEventProvider lifecycleEventProvider, Consumer<LifecycleEventProvider> eventDispatcher) {
        RegistryEvent.NewRegistry newRegistryEvent = new RegistryEvent.NewRegistry();
        lifecycleEventProvider.setCustomEventSupplier(() -> newRegistryEvent);
        eventDispatcher.accept(lifecycleEventProvider);
    }

    public static void fireRegistryEvents(Predicate<ResourceLocation> filter, LifecycleEventProvider lifecycleEventProvider, Consumer<LifecycleEventProvider> eventDispatcher) {
        ArrayList keys = Lists.newArrayList((Iterable)RegistryManager.ACTIVE.registries.keySet());
        keys.sort((o1, o2) -> String.valueOf(o1).compareToIgnoreCase(String.valueOf(o2)));
        keys.remove(BLOCKS);
        keys.remove(ITEMS);
        keys.add(0, BLOCKS);
        keys.add(1, ITEMS);
        int keysSize = keys.size();
        for (int i = 0; i < keysSize; ++i) {
            ResourceLocation rl = (ResourceLocation)keys.get(i);
            if (!filter.test(rl)) continue;
            ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(rl);
            reg.unfreeze();
            StartupMessageManager.modLoaderConsumer().ifPresent(s -> s.accept("REGISTERING " + rl));
            RegistryEvent.Register registerEvent = reg.getRegisterEvent(rl);
            lifecycleEventProvider.setCustomEventSupplier(() -> registerEvent);
            lifecycleEventProvider.changeProgression(LifecycleEventProvider.LifecycleEvent.Progression.STAY);
            if (i == keysSize - 1) {
                lifecycleEventProvider.changeProgression(LifecycleEventProvider.LifecycleEvent.Progression.NEXT);
            }
            eventDispatcher.accept(lifecycleEventProvider);
            reg.freeze();
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Applying holder lookups: {}", (Object)rl.toString());
            ObjectHolderRegistry.applyObjectHolders(arg_0 -> ((ResourceLocation)rl).equals(arg_0));
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Holder lookups applied: {}", (Object)rl.toString());
        }
    }

    public static ResourceLocation checkPrefix(String name, boolean warnOverrides) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        String prefix = ModLoadingContext.get().getActiveNamespace();
        if (warnOverrides && !oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            LogManager.getLogger().info("Potentially Dangerous alternative prefix `{}` for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)oldPrefix, (Object)name, (Object)prefix);
            prefix = oldPrefix;
        }
        return new ResourceLocation(prefix, name);
    }

    private static void forceRegistryName(IForgeRegistryEntry<?> entry, ResourceLocation name) {
        if (regName == null) {
            try {
                regName = ForgeRegistryEntry.class.getDeclaredField("registryName");
                regName.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                LOGGER.error(ForgeRegistry.REGISTRIES, "Could not get `registryName` field from IForgeRegistryEntry.Impl", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            regName.set(entry, name);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error(ForgeRegistry.REGISTRIES, "Could not set `registryName` field in IForgeRegistryEntry.Impl to `{}`", (Object)name.toString(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$injectSnapshot$25(RegistryManager STAGING, Multimap failed, Map remaps, Multimap defaulted, boolean isLocalWorld, Map.Entry m) {
        ResourceLocation name = (ResourceLocation)m.getKey();
        ForgeRegistry reg = STAGING.getRegistry(name);
        RegistryEvent.MissingMappings<?> event = reg.getMissingEvent(name, (Map)m.getValue());
        MinecraftForge.EVENT_BUS.post(event);
        List lst = event.getAllMappings().stream().filter(e -> e.getAction() == RegistryEvent.MissingMappings.Action.DEFAULT).sorted((a, b) -> a.toString().compareTo(b.toString())).collect(Collectors.toList());
        if (!lst.isEmpty()) {
            LOGGER.error(ForgeRegistry.REGISTRIES, () -> new AdvancedLogMessageAdapter(sb -> {
                sb.append("Unidentified mapping from registry ").append(name).append('\n');
                lst.forEach(map -> sb.append('\t').append(map.key).append(": ").append(map.id).append('\n'));
            }));
        }
        event.getAllMappings().stream().filter(e -> e.getAction() == RegistryEvent.MissingMappings.Action.FAIL).forEach(fail -> failed.put((Object)name, (Object)fail.key));
        Class clazz = RegistryManager.ACTIVE.getSuperType(name);
        GameData.processMissing(clazz, name, STAGING, event, (Map)m.getValue(), (Map)remaps.get(name), defaulted.get((Object)name), failed.get((Object)name), !isLocalWorld);
    }

    static {
        GameData.init();
    }

    private static class FeatureCallbacks
    implements IForgeRegistry.AddCallback<Feature<?>>,
    IForgeRegistry.ClearCallback<Feature<?>>,
    IForgeRegistry.CreateCallback<Feature<?>> {
        static final FeatureCallbacks INSTANCE = new FeatureCallbacks();

        private FeatureCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Feature<?>> owner, RegistryManager stage, int id, Feature<?> obj, Feature<?> oldObj) {
            if (obj instanceof Structure) {
                Structure structure = (Structure)obj;
                String key = structure.func_143025_a().toLowerCase(Locale.ROOT);
                Registry reg = owner.getSlaveMap(STRUCTURE_FEATURES, Registry.class);
                Registry.func_218325_a((Registry)reg, (String)key, (Object)structure);
                BiMap map = owner.getSlaveMap(STRUCTURES, BiMap.class);
                if (oldObj != null && oldObj instanceof Structure) {
                    map.remove((Object)((Structure)oldObj).func_143025_a());
                }
                map.put((Object)key, (Object)structure);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Feature<?>> owner, RegistryManager stage) {
            owner.getSlaveMap(STRUCTURE_FEATURES, ClearableRegistry.class).clear();
            owner.getSlaveMap(STRUCTURES, BiMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Feature<?>> owner, RegistryManager stage) {
            owner.setSlaveMap(STRUCTURE_FEATURES, (Object)new ClearableRegistry(owner.getRegistryName()));
            owner.setSlaveMap(STRUCTURES, HashBiMap.create());
        }
    }

    private static class SerializerCallbacks
    implements IForgeRegistry.AddCallback<DataSerializerEntry>,
    IForgeRegistry.ClearCallback<DataSerializerEntry>,
    IForgeRegistry.CreateCallback<DataSerializerEntry> {
        static final SerializerCallbacks INSTANCE = new SerializerCallbacks();

        private SerializerCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage, int id, DataSerializerEntry entry, @Nullable DataSerializerEntry oldEntry) {
            Map map = owner.getSlaveMap(SERIALIZER_TO_ENTRY, Map.class);
            if (oldEntry != null) {
                map.remove(oldEntry.getSerializer());
            }
            map.put(entry.getSerializer(), entry);
        }

        @Override
        public void onClear(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage) {
            owner.getSlaveMap(SERIALIZER_TO_ENTRY, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage) {
            owner.setSlaveMap(SERIALIZER_TO_ENTRY, new IdentityHashMap());
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<Item>,
    IForgeRegistry.ClearCallback<Item>,
    IForgeRegistry.CreateCallback<Item> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Item> owner, RegistryManager stage, int id, Item item, @Nullable Item oldItem) {
            Map blockToItem;
            if (oldItem instanceof BlockItem) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((BlockItem)oldItem).removeFromBlockToItemMap(blockToItem, item);
            }
            if (item instanceof BlockItem) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((BlockItem)item).func_195946_a(blockToItem, item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCK_TO_ITEM, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            Map map = stage.getRegistry(BLOCKS).getSlaveMap(BLOCK_TO_ITEM, Map.class);
            owner.setSlaveMap(BLOCK_TO_ITEM, map);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<Block>,
    IForgeRegistry.ClearCallback<Block>,
    IForgeRegistry.BakeCallback<Block>,
    IForgeRegistry.CreateCallback<Block>,
    IForgeRegistry.DummyFactory<Block> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Block> owner, RegistryManager stage, int id, Block block, @Nullable Block oldBlock) {
            if (oldBlock != null) {
                StateContainer oldContainer = oldBlock.func_176194_O();
                StateContainer newContainer = block.func_176194_O();
                if (block.getRegistryName().func_110624_b().equals("minecraft") && !oldContainer.func_177623_d().equals(newContainer.func_177623_d())) {
                    String oldSequence = oldContainer.func_177623_d().stream().map(s -> String.format("%s={%s}", s.func_177701_a(), s.func_177700_c().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    String newSequence = newContainer.func_177623_d().stream().map(s -> String.format("%s={%s}", s.func_177701_a(), s.func_177700_c().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    LOGGER.error(ForgeRegistry.REGISTRIES, () -> new AdvancedLogMessageAdapter(sb -> {
                        sb.append("Registry replacements for vanilla block '").append(block.getRegistryName()).append("' must not change the number or order of blockstates.\n");
                        sb.append("\tOld: ").append(oldSequence).append('\n');
                        sb.append("\tNew: ").append(newSequence);
                    }));
                    throw new RuntimeException("Invalid vanilla replacement. See log for details.");
                }
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap<BlockState> idMap = new ClearableObjectIntIdentityMap<BlockState>(){

                public int get(BlockState key) {
                    Integer integer = (Integer)this.field_148749_a.get(key);
                    return integer == null ? -1 : integer;
                }
            };
            owner.setSlaveMap(BLOCKSTATE_TO_ID, idMap);
            owner.setSlaveMap(BLOCK_TO_ITEM, Maps.newHashMap());
        }

        @Override
        public Block createDummy(ResourceLocation key) {
            BlockDummyAir ret = new BlockDummyAir(Block.Properties.func_200945_a((Material)Material.field_151579_a));
            GameData.forceRegistryName((IForgeRegistryEntry)((Object)ret), key);
            return ret;
        }

        @Override
        public void onBake(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap blockstateMap = owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class);
            for (Block block : owner) {
                for (BlockState state : block.func_176194_O().func_177619_a()) {
                    blockstateMap.func_195867_b(state);
                    state.func_215692_c();
                }
                block.func_220068_i();
            }
        }

        private static class BlockDummyAir
        extends AirBlock {
            private BlockDummyAir(Block.Properties properties) {
                super(properties);
            }

            public String func_149739_a() {
                return "block.minecraft.air";
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends ObjectIntIdentityMap<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.field_148749_a.clear();
            this.field_148748_b.clear();
            this.field_195868_a = 0;
        }

        void remove(I key) {
            Integer prev = (Integer)this.field_148749_a.remove(key);
            if (prev != null) {
                this.field_148748_b.set(prev, null);
            }
        }
    }
}

