/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.StartupQuery;

public class NotificationScreen
extends Screen {
    protected static final int PADDING = 6;
    protected final StartupQuery query;
    private final String[] headerLines;
    private final String[] textLines;
    private final String action;
    private ScrollPanel textPanel;

    public NotificationScreen(StartupQuery query) {
        super((ITextComponent)new TranslationTextComponent("fml.menu.notification.title", new Object[0]));
        this.query = query;
        this.headerLines = query.getHeader().isEmpty() ? new String[]{} : query.getHeader().split("\n");
        this.textLines = query.getText().split("\n");
        this.action = query.getAction();
    }

    public void init() {
        super.init();
        int n = this.headerLines.length;
        this.font.getClass();
        int panelY = 6 + n * 9 + 6;
        int panelHeight = this.height - 6 - 20 - panelY;
        if (!this.action.isEmpty()) {
            this.font.getClass();
            panelHeight = panelHeight - 9 - 6;
        }
        this.textPanel = new TextPanel(this.minecraft, this.width - 12, panelHeight, panelY, 6);
        this.children.add(this.textPanel);
        this.addConfirmationButtons();
    }

    protected void addConfirmationButtons() {
        this.buttons.add(new Button(this.width / 2 - 100, this.height - 6 - 20, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.minecraft.func_147108_a(null);
            this.query.finish();
        }));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredLines(6, this.headerLines);
        if (this.textPanel != null) {
            this.textPanel.render(mouseX, mouseY, partialTicks);
        }
        if (!this.action.isEmpty()) {
            int n = this.width / 2;
            this.font.getClass();
            this.drawCenteredString(this.font, this.action, n, this.height - 6 - 20 - 9, -1);
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void drawCenteredLines(int yStart, String ... lines) {
        for (String line : lines) {
            if (!line.isEmpty()) {
                this.drawCenteredString(this.font, line, this.width / 2, yStart, 0xFFFFFF);
            }
            this.font.getClass();
            yStart += 9;
        }
    }

    private class TextPanel
    extends ScrollPanel {
        TextPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
        }

        @Override
        protected int getContentHeight() {
            int height = 0;
            int n = NotificationScreen.this.textLines.length;
            NotificationScreen.this.font.getClass();
            if ((height += n * 9 + 4) < this.height - 50) {
                height = this.height - 50;
            }
            return height;
        }

        @Override
        protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            NotificationScreen.this.drawCenteredLines(relativeY, NotificationScreen.this.textLines);
        }

        @Override
        protected int getScrollAmount() {
            NotificationScreen.this.font.getClass();
            return 9 * 3;
        }
    }
}

