/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.apache.commons.io.IOUtils;

public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList found = Lists.newArrayList();
        FMLLog.log.debug("Examining directory {} for potential mods", new Object[]{candidate.getModContainer().getName()});
        this.exploreFileSystem("", candidate.getModContainer(), found, candidate, null);
        for (ModContainer mc : found) {
            table.addContainer(mc);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, @Nullable MetadataCollection mc) {
        if (path.length() == 0) {
            File metadata = new File(modDir, "mcmod.info");
            try {
                FileInputStream fis = new FileInputStream(metadata);
                try {
                    mc = MetadataCollection.from(fis, modDir.getName());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                FMLLog.log.debug("Found an mcmod.info file in directory {}", new Object[]{modDir.getName()});
            }
            catch (Exception e2) {
                mc = MetadataCollection.from(null, "");
                FMLLog.log.debug("No mcmod.info file found in directory {}", new Object[]{modDir.getName()});
            }
        }
        Object[] content = modDir.listFiles(new ClassFilter());
        Arrays.sort(content);
        Object[] objectArray = content;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object file = objectArray[n3];
            if (((File)file).isDirectory()) {
                FMLLog.log.trace("Recursing into package {}", new Object[]{path + ((File)file).getName()});
                this.exploreFileSystem(path + ((File)file).getName() + "/", (File)file, harvestedMods, candidate, mc);
            } else {
                Matcher match = classFile.matcher(((File)file).getName());
                if (match.matches()) {
                    ASMModParser modParser = null;
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream((File)file);
                        modParser = new ASMModParser(fis);
                        candidate.addClassEntry(path + ((File)file).getName());
                    }
                    catch (LoaderException e3) {
                        try {
                            FMLLog.log.error("There was a problem reading the file {} - probably this is a corrupt file", new Object[]{((File)file).getPath(), e3});
                            throw e3;
                            catch (Exception e4) {
                                throw Throwables.propagate((Throwable)e4);
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    modParser.validate();
                    modParser.sendToTable(this.table, candidate);
                    ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                    if (container != null) {
                        harvestedMods.add(container);
                        container.bindMetadata(mc);
                    }
                }
            }
            ++n3;
        }
        return;
    }

    private class ClassFilter
    implements FileFilter {
        private ClassFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && ITypeDiscoverer.classFile.matcher(file.getName()).matches() || file.isDirectory();
        }
    }
}

