/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;

public class ModAccessTransformer
extends AccessTransformer {
    private static Map<String, String> embedded = Maps.newHashMap();

    public ModAccessTransformer() throws Exception {
        super(ModAccessTransformer.class);
        ClassLoader classLoader = this.getClass().getClassLoader().getClass().getClassLoader();
        Class<?> otherClazz = Class.forName(this.getClass().getName(), true, classLoader);
        Field otherField = otherClazz.getDeclaredField("embedded");
        otherField.setAccessible(true);
        embedded = (Map)otherField.get(null);
        for (Map.Entry<String, String> e2 : embedded.entrySet()) {
            int old_count = this.getModifiers().size();
            this.processATFile(CharSource.wrap((CharSequence)e2.getValue()));
            int added = this.getModifiers().size() - old_count;
            if (added <= 0) continue;
            FMLLog.log.debug("Loaded {} rules from AccessTransformer mod jar file {}\n", new Object[]{added, e2.getKey()});
        }
    }

    public static void addJar(JarFile jar) throws IOException {
        Manifest manifest = jar.getManifest();
        String atList = manifest.getMainAttributes().getValue("FMLAT");
        if (atList == null) {
            return;
        }
        for (String at : atList.split(" ")) {
            JarEntry jarEntry = jar.getJarEntry("META-INF/" + at);
            if (jarEntry == null) continue;
            embedded.put(String.format("%s!META-INF/%s", jar.getName(), at), new JarByteSource(jar, jarEntry).asCharSource(Charsets.UTF_8).read());
        }
    }

    private static class JarByteSource
    extends ByteSource {
        private JarFile jar;
        private JarEntry entry;

        public JarByteSource(JarFile jar, JarEntry entry) {
            this.jar = jar;
            this.entry = entry;
        }

        public InputStream openStream() throws IOException {
            return this.jar.getInputStream(this.entry);
        }
    }
}

