/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class AchievementPage {
    private String name;
    private LinkedList<nq> achievements;
    private static LinkedList<AchievementPage> achievementPages = new LinkedList();

    public AchievementPage(String name, nq ... achievements) {
        this.name = name;
        this.achievements = new LinkedList<nq>(Arrays.asList(achievements));
    }

    public String getName() {
        return this.name;
    }

    public List<nq> getAchievements() {
        return this.achievements;
    }

    public static void registerAchievementPage(AchievementPage page) {
        if (AchievementPage.getAchievementPage(page.getName()) != null) {
            throw new RuntimeException("Duplicate achievement page name \"" + page.getName() + "\"!");
        }
        achievementPages.add(page);
    }

    public static AchievementPage getAchievementPage(int index) {
        return achievementPages.get(index);
    }

    @Nullable
    public static AchievementPage getAchievementPage(String name) {
        for (AchievementPage page : achievementPages) {
            if (!page.getName().equals(name)) continue;
            return page;
        }
        return null;
    }

    public static Set<AchievementPage> getAchievementPages() {
        return new HashSet<AchievementPage>(achievementPages);
    }

    public static boolean isAchievementInPages(nq achievement) {
        for (AchievementPage page : achievementPages) {
            if (!page.getAchievements().contains(achievement)) continue;
            return true;
        }
        return false;
    }

    public static String getTitle(int index) {
        return index == -1 ? "Minecraft" : AchievementPage.getAchievementPage(index).getName();
    }
}

