/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ForgeBlockStateV1.class, (Object)ForgeBlockStateV1.Deserializer.INSTANCE).registerTypeAdapter(ForgeBlockStateV1.Variant.class, (Object)ForgeBlockStateV1.Variant.Deserializer.INSTANCE).registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();

    public static brj load(Reader reader, Gson vanillaGSON) {
        try {
            byte[] data = IOUtils.toByteArray((Reader)reader);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), Charsets.UTF_8);
            Marker marker = (Marker)GSON.fromJson(new String(data), Marker.class);
            switch (marker.forge_marker) {
                case 1: {
                    ForgeBlockStateV1 v1 = (ForgeBlockStateV1)GSON.fromJson(reader, ForgeBlockStateV1.class);
                    HashMap variants = Maps.newHashMap();
                    for (Map.Entry entry : v1.variants.asMap().entrySet()) {
                        ArrayList mcVars = Lists.newArrayList();
                        for (ForgeBlockStateV1.Variant var : (Collection)entry.getValue()) {
                            boolean uvLock = (Boolean)var.getUvLock().or((Object)false);
                            boolean smooth = (Boolean)var.getSmooth().or((Object)true);
                            boolean gui3d = (Boolean)var.getGui3d().or((Object)true);
                            int weight = (Integer)var.getWeight().or((Object)1);
                            if (var.getModel() != null && var.getSubmodels().size() == 0 && var.getTextures().size() == 0 && var.getCustomData().size() == 0 && var.getState().orNull() instanceof cbi) {
                                mcVars.add(new brs(var.getModel(), (cbi)var.getState().get(), uvLock, weight));
                                continue;
                            }
                            mcVars.add(new ForgeVariant(var.getModel(), (IModelState)var.getState().or((Object)TRSRTransformation.identity()), uvLock, smooth, gui3d, weight, var.getTextures(), var.getOnlyPartsVariant(), var.getCustomData()));
                        }
                        variants.put(entry.getKey(), new brr((List)mcVars));
                    }
                    return new brj((Map)variants, null);
                }
            }
            return (brj)vanillaGSON.fromJson(reader, brj.class);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    private static class ForgeVariant
    extends brs
    implements ISmartVariant {
        private final ImmutableMap<String, String> textures;
        private final ImmutableMap<String, SubModel> parts;
        private final ImmutableMap<String, String> customData;
        private final boolean smooth;
        private final boolean gui3d;
        private final IModelState state;

        public ForgeVariant(kq model, IModelState state, boolean uvLock, boolean smooth, boolean gui3d, int weight, ImmutableMap<String, String> textures, ImmutableMap<String, SubModel> parts, ImmutableMap<String, String> customData) {
            super(model == null ? new kq("builtin/missing") : model, state instanceof cbi ? (cbi)state : cbi.a, uvLock, weight);
            this.textures = textures;
            this.parts = parts;
            this.customData = customData;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
        }

        private IModel runModelHooks(IModel base, boolean smooth, boolean gui3d, boolean uvlock, ImmutableMap<String, String> textureMap, ImmutableMap<String, String> customData) {
            base = ModelProcessingHelper.customData(base, customData);
            base = ModelProcessingHelper.retexture(base, textureMap);
            base = ModelProcessingHelper.smoothLighting(base, smooth);
            base = ModelProcessingHelper.gui3d(base, gui3d);
            base = ModelProcessingHelper.uvlock(base, uvlock);
            return base;
        }

        @Override
        public IModel process(IModel base) {
            boolean hasBase;
            int size = this.parts.size();
            boolean bl = hasBase = base != ModelLoaderRegistry.getMissingModel();
            if (hasBase) {
                base = this.runModelHooks(base, this.smooth, this.gui3d, this.c(), this.textures, this.customData);
                if (size <= 0) {
                    return base;
                }
            }
            IModelState baseTr = this.getState();
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry entry : this.parts.entrySet()) {
                SubModel part = (SubModel)entry.getValue();
                IModel model = ModelLoaderRegistry.getModelOrLogError(part.getModelLocation(), "Unable to load block sub-model: '" + part.getModelLocation());
                models.put(entry.getKey(), (Object)Pair.of((Object)this.runModelHooks(model, part.smooth, part.gui3d, part.uvLock, part.getTextures(), part.getCustomData()), (Object)part.getState()));
            }
            return new MultiModel(this.a(), hasBase ? base : null, baseTr, (ImmutableMap<String, Pair<IModel, IModelState>>)models.build());
        }

        public IModelState getState() {
            return this.state;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("TexturedVariant:");
            for (Map.Entry e : this.textures.entrySet()) {
                buf.append(" ").append((String)e.getKey()).append(" = ").append((String)e.getValue());
            }
            return buf.toString();
        }
    }

    public static class SubModel {
        private final IModelState state;
        private final boolean uvLock;
        private final boolean smooth;
        private final boolean gui3d;
        private final ImmutableMap<String, String> textures;
        private final kq model;
        private final ImmutableMap<String, String> customData;

        public SubModel(IModelState state, boolean uvLock, boolean smooth, boolean gui3d, ImmutableMap<String, String> textures, kq model, ImmutableMap<String, String> customData) {
            this.state = state;
            this.uvLock = uvLock;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.textures = textures;
            this.model = model;
            this.customData = customData;
        }

        public IModelState getState() {
            return this.state;
        }

        public boolean isUVLock() {
            return this.uvLock;
        }

        public ImmutableMap<String, String> getTextures() {
            return this.textures;
        }

        public kq getModelLocation() {
            return this.model;
        }

        public ImmutableMap<String, String> getCustomData() {
            return this.customData;
        }
    }

    public static class Marker {
        public int forge_marker = -1;
    }
}

