/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.common.jimfs.Jimfs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import net.minecraftforge.fml.loading.targets.ForgeDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.UnionHelper;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@ApiStatus.Internal
public final class ForgeDevLocator
extends AbstractModProvider
implements IModLocator {
    private static final String PACK_META = "pack.mcmeta";

    public String name() {
        return "forge_dev_locator";
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        CommonLaunchHandler handler = FMLLoader.getLaunchHandler();
        if (!(handler instanceof ForgeDevLaunchHandler)) {
            return List.of();
        }
        List<Path> mods = ForgeDevLocator.getMods();
        ArrayList<IModLocator.ModFileOrException> ret = new ArrayList<IModLocator.ModFileOrException>();
        for (Path path : mods) {
            IModLocator.ModFileOrException mod = this.createMod(path);
            if (mod == null) continue;
            ret.add(mod);
        }
        return ret;
    }

    private static List<Path> getMods() {
        Path forge;
        Path minecraft = ForgeDevLaunchHandler.getPathFromResource("net/minecraft/client/Minecraft.class");
        if (minecraft.equals(forge = ForgeDevLaunchHandler.getPathFromResource("net/minecraftforge/common/MinecraftForge.class"))) {
            forge = CommonDevLaunchHandler.getForgeOnly(forge);
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        ret.add(forge);
        boolean isTest = Boolean.getBoolean("forgedev.enableTestMods");
        if (!isTest) {
            return ret;
        }
        Path test = ForgeDevLaunchHandler.getPathFromResource("net/minecraftforge/test/BaseTestMod.class", ClassLoader.getSystemClassLoader());
        List<Path> tests = ForgeDevLocator.explodeTestMods(test);
        ret.addAll(tests);
        return ret;
    }

    private static List<Path> explodeTestMods(Path path) {
        ArrayList<Path> mod = new ArrayList<Path>();
        FileSystem memory = Jimfs.newFileSystem();
        Map<String, Set<String>> packages = ForgeDevLocator.findTestModPackages(path);
        for (Map.Entry<String, Set<String>> entry : packages.entrySet()) {
            String pkg = entry.getKey() + "/";
            Set<String> modids = entry.getValue();
            LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
            for (String modid : modids) {
                Path rsc = path.resolve(modid);
                if (!Files.exists(rsc, new LinkOption[0])) continue;
                paths.add(rsc);
            }
            Path root = memory.getPath(modids.iterator().next(), new String[0]);
            ForgeDevLocator.buildModsToml(paths, modids, root);
            ForgeDevLocator.buildPackMeta(paths, root);
            ForgeDevLocator.moveModuleInfo(paths, root);
            if (Files.exists(root, new LinkOption[0])) {
                paths.add(root);
            }
            FileSystem classes = UnionHelper.newFileSystem((name, base) -> {
                if (name.endsWith("/")) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    return pkg.startsWith((String)name) || name.startsWith(pkg);
                }
                return name.endsWith(".class") && name.startsWith(pkg);
            }, new Path[]{path});
            paths.addFirst(classes.getRootDirectories().iterator().next());
            FileSystem union = UnionHelper.newFileSystem(null, (Path[])paths.stream().toArray(Path[]::new));
            mod.add(union.getRootDirectories().iterator().next());
        }
        return mod;
    }

    private static Map<String, Set<String>> findTestModPackages(Path path) {
        final HashMap<String, Set<String>> mods = new HashMap<String, Set<String>>();
        try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]);){
            List<Path> classes = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".class")).toList();
            for (Path cls : classes) {
                InputStream is = Files.newInputStream(cls, new OpenOption[0]);
                try {
                    ClassReader reader = new ClassReader(is);
                    reader.accept(new ClassVisitor(589824){
                        private String clsName;

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            this.clsName = name;
                            super.visit(version, access, name, signature, superName, interfaces);
                        }

                        public AnnotationVisitor visitAnnotation(String name, boolean runtime) {
                            if (!"Lnet/minecraftforge/fml/common/Mod;".equals(name)) {
                                return super.visitAnnotation(name, runtime);
                            }
                            return new AnnotationVisitor(589824){

                                public void visit(String key, Object value) {
                                    if ("value".equals(key)) {
                                        int idx = clsName.lastIndexOf(47);
                                        String pkg = clsName.substring(0, idx);
                                        mods.computeIfAbsent(pkg, k -> new HashSet()).add((String)value);
                                        idx = pkg.lastIndexOf(47);
                                        while (idx != -1) {
                                            pkg = pkg.substring(0, idx);
                                            idx = pkg.lastIndexOf(47);
                                            if (!mods.containsKey(pkg)) continue;
                                            throw new IllegalStateException("Invalid ForgeDev test mod layout, conflicting packages: " + pkg + " for " + clsName);
                                        }
                                    }
                                }
                            };
                        }
                    }, 7);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            ForgeDevLocator.sneak(e);
        }
        return mods;
    }

    private static void buildModsToml(Set<Path> resources, Set<String> modids, Path root) {
        Path toml = resources.stream().map(p -> p.resolve("META-INF/mods.toml")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
        Config cfg = null;
        cfg = toml != null ? new TomlParser().parse(toml, FileNotFoundAction.READ_NOTHING) : Config.inMemory();
        boolean modified = false;
        Map<String, String> defaults = Map.of("modLoader", "javafml", "loaderVersion", "[0,)", "license", "Doesnt fucking matter");
        for (String key : defaults.keySet()) {
            if (cfg.contains(key)) continue;
            cfg.set(key, (Object)defaults.get(key));
            modified = true;
        }
        ArrayList<Config> modlist = new ArrayList<Config>();
        if (cfg.contains("mods")) {
            List existing = (List)cfg.get("mods");
            modlist.addAll(existing);
        }
        for (String modid : modids) {
            if (!modlist.stream().noneMatch(c -> modid.equals(c.get("modId")))) continue;
            modified = true;
            Config tmp = Config.inMemory();
            tmp.set("modId", (Object)modid);
            modlist.add(tmp);
        }
        cfg.set("mods", modlist);
        if (modified) {
            Path target = root.resolve("META-INF/mods.toml");
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                new TomlWriter().write((UnmodifiableConfig)cfg, target, WritingMode.REPLACE);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create in memory toml: " + String.valueOf(target), e);
            }
        }
    }

    private static void buildPackMeta(Set<Path> paths, Path root) {
        Path existing = paths.stream().map(p -> p.resolve(PACK_META)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
        if (existing != null) {
            return;
        }
        Path target = root.resolve(PACK_META);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.writeString(target, (CharSequence)"{\n    \"pack\": {\n        \"description\": \"doesn't matter\",\n        \"pack_format\": 18\n     }\n}\n", StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to make in memory pack.mcmeta: " + String.valueOf(target), e);
        }
    }

    private static void moveModuleInfo(Set<Path> paths, Path root) {
        Path existing = paths.stream().map(p -> p.resolve("module-info.dat")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
        if (existing == null) {
            return;
        }
        Path target = root.resolve("module-info.class");
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(existing, target, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy module-info.dat to memory: " + String.valueOf(target), e);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }
}

