/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MinecraftLocator
extends AbstractModProvider
implements IModLocator {
    public List<IModLocator.ModFileOrException> scanMods() {
        List<Path> minecraft = FMLLoader.getLaunchHandler().getMinecraftPaths();
        Path[] paths = (Path[])minecraft.toArray(Path[]::new);
        ModJarMetadata meta = new ModJarMetadata();
        SecureJar mcjar = SecureJar.from(jar -> meta, (Path[])paths);
        IModFile mc = ModFileFactory.FACTORY.build(mcjar, (IModProvider)this, MinecraftLocator::buildMinecraftTOML);
        meta.setModFile(mc);
        return List.of(new IModLocator.ModFileOrException(mc, null));
    }

    private static IModFileInfo buildMinecraftTOML(IModFile iModFile) {
        Config conf = Config.inMemory();
        conf.set("modLoader", (Object)"minecraft");
        conf.set("loaderVersion", (Object)"1");
        conf.set("license", (Object)"Mojang Studios, All Rights Reserved");
        Config mods = Config.inMemory();
        mods.set("modId", (Object)"minecraft");
        mods.set("version", (Object)FMLLoader.versionInfo().mcVersion());
        mods.set("displayName", (Object)"Minecraft");
        mods.set("logoFile", (Object)"mcplogo.png");
        mods.set("credits", (Object)"Mojang, deobfuscated by MCP");
        mods.set("authors", (Object)"MCP: Searge,ProfMobius,IngisKahn,Fesh0r,ZeuX,R4wk,LexManos,Bspkrs");
        mods.set("description", (Object)"Minecraft, decompiled and deobfuscated with MCP technology");
        conf.set("mods", List.of(mods));
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)conf);
        return new ModFileInfo((ModFile)iModFile, configWrapper, configWrapper::setFile);
    }

    public String name() {
        return "minecraft";
    }
}

