/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import net.minecraftforge.jarjar.selection.JarSelector;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ApiStatus.Internal
public class JarInJarDependencyLocator
extends AbstractModProvider
implements IDependencyLocator {
    private static final String COLOR_CODE = "\u00a7";
    private static final String RESET = "\u00a7r";
    private static final String YELLOW = "\u00a7e";
    private static final String RED = "\u00a74";
    private static final String GREEN = "\u00a72";
    private static final Logger LOGGER = LogUtils.getLogger();

    public String name() {
        return "JarInJar";
    }

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList sources = Lists.newArrayList();
        loadedMods.forEach(sources::add);
        List dependenciesToLoad = JarSelector.detectAndSelect((List)sources, this::loadResourceFromModFile, this::loadModFileFrom, this::identifyMod, this::exception);
        if (dependenciesToLoad.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
            return Collections.emptyList();
        }
        LOGGER.info("Found {} dependencies adding them to mods collection", (Object)dependenciesToLoad.size());
        return dependenciesToLoad;
    }

    @Override
    protected String getDefaultJarModType() {
        return IModFile.Type.GAMELIBRARY.name();
    }

    protected Optional<IModFile> loadModFileFrom(IModFile file, Path path) {
        try {
            Path pathInModFile = file.findResource(new String[]{path.toString()});
            URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
            ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
            FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
            Path pathInFS = zipFS.getPath("/", new String[0]);
            IModFile.Type parentType = file.getType();
            String modType = parentType == IModFile.Type.LIBRARY || parentType == IModFile.Type.LANGPROVIDER ? IModFile.Type.LIBRARY.name() : IModFile.Type.GAMELIBRARY.name();
            return Optional.of(this.createMod(pathInFS, false, modType).file());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mod file {} from {}", (Object)path, (Object)file.getFileName());
            ModFileLoadingException exception = new ModFileLoadingException("Failed to load mod file " + file.getFileName());
            exception.initCause(e);
            throw exception;
        }
    }

    protected EarlyLoadingException exception(Collection<JarSelector.ResolutionFailureInformation<IModFile>> failedDependencies) {
        List<EarlyLoadingException.ExceptionData> errors = failedDependencies.stream().filter(entry -> !entry.sources().isEmpty()).map(this::buildExceptionData).toList();
        return new EarlyLoadingException(failedDependencies.size() + " Dependency restrictions were not met.", null, errors);
    }

    @NotNull
    private EarlyLoadingException.ExceptionData buildExceptionData(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return new EarlyLoadingException.ExceptionData(this.getErrorTranslationKey(entry), entry.identifier().group() + ":" + entry.identifier().artifact(), entry.sources().stream().flatMap(this::getModWithVersionRangeStream).map(this::formatError).collect(Collectors.joining(", ")));
    }

    @NotNull
    private String getErrorTranslationKey(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return entry.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.dependencyloading.conflictingdependencies" : "fml.dependencyloading.mismatchedcontaineddependencies";
    }

    @NotNull
    private Stream<ModWithVersionRange> getModWithVersionRangeStream(JarSelector.SourceWithRequestedVersionRange<IModFile> file) {
        return file.sources().stream().map(IModFile::getModFileInfo).flatMap(modFileInfo -> modFileInfo.getMods().stream()).map(modInfo -> new ModWithVersionRange((IModInfo)modInfo, file.requestedVersionRange(), file.includedVersion()));
    }

    protected Optional<InputStream> loadResourceFromModFile(IModFile modFile, Path path) {
        try {
            Path pathInModFile = modFile.findResource(new String[]{path.toString()});
            if (!Files.exists(pathInModFile, new LinkOption[0])) {
                LOGGER.debug("Failed to load resource {} from {}, it does not contain dependency information.", (Object)path, (Object)modFile.getFileName());
                return Optional.empty();
            }
            return Optional.of(Files.newInputStream(pathInModFile, new OpenOption[0]));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load resource {} from mod {}, cause {}", new Object[]{path, modFile.getFileName(), e});
            return Optional.empty();
        }
    }

    @NotNull
    private String formatError(ModWithVersionRange modWithVersionRange) {
        return YELLOW + modWithVersionRange.modInfo().getModId() + "\u00a7r - \u00a74" + modWithVersionRange.versionRange().toString() + "\u00a7r - \u00a72" + modWithVersionRange.artifactVersion().toString() + RESET;
    }

    protected String identifyMod(IModFile modFile) {
        if (modFile.getModFileInfo() != null && !modFile.getModInfos().isEmpty()) {
            return modFile.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining());
        }
        String module = modFile.getSecureJar().moduleDataProvider().name();
        if (module != null && !module.isEmpty()) {
            return module;
        }
        return modFile.getFileName();
    }

    private record ModWithVersionRange(IModInfo modInfo, VersionRange versionRange, ArtifactVersion artifactVersion) {
    }
}

