/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class ForgeDevLaunchHandler
extends CommonDevLaunchHandler {
    private ForgeDevLaunchHandler(CommonLaunchHandler.LaunchType type) {
        super(type, "forge_dev_");
    }

    @Override
    public List<Path> getMinecraftPaths() {
        String[] legacyCP = ForgeDevLaunchHandler.findClassPath();
        Path extra = ForgeDevLaunchHandler.findJarOnClasspath(legacyCP, "client-extra");
        Path minecraft = ForgeDevLaunchHandler.getPathFromResource("net/minecraft/client/Minecraft.class");
        Path forge = ForgeDevLaunchHandler.getPathFromResource("net/minecraftforge/common/MinecraftForge.class");
        if (!forge.equals(minecraft)) {
            return List.of(minecraft, extra);
        }
        Path filtered = CommonDevLaunchHandler.getMinecraftOnly(extra, minecraft);
        return List.of(filtered);
    }

    public static class ServerGameTest
    extends ForgeDevLaunchHandler {
        public ServerGameTest() {
            super(SERVER_GAMETEST);
        }
    }

    public static class Server
    extends ForgeDevLaunchHandler {
        public Server() {
            super(SERVER);
        }
    }

    public static class Data
    extends ForgeDevLaunchHandler {
        public Data() {
            super(DATA);
        }
    }

    public static class Client
    extends ForgeDevLaunchHandler {
        public Client() {
            super(CLIENT);
        }
    }
}

