/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import java.lang.module.ModuleDescriptor;
import java.util.Objects;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModJarMetadata
implements JarMetadata {
    private IModFile modFile;
    private ModuleDescriptor descriptor;

    ModJarMetadata() {
    }

    public void setModFile(IModFile file) {
        this.modFile = file;
    }

    public String name() {
        return this.modFile.getModFileInfo().moduleName();
    }

    public String version() {
        return this.modFile.getModFileInfo().versionString();
    }

    public ModuleDescriptor descriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name()).version(this.version()).packages(this.modFile.getSecureJar().getPackages());
        this.modFile.getSecureJar().getProviders().stream().filter(p -> !p.providers().isEmpty()).forEach(p -> bld.provides(p.serviceName(), p.providers()));
        this.modFile.getModFileInfo().usesServices().forEach(bld::uses);
        this.descriptor = bld.build();
        return this.descriptor;
    }

    public IModFile modFile() {
        return this.modFile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)obj;
        return Objects.equals(this.modFile, that.modFile);
    }

    public int hashCode() {
        return Objects.hash(this.modFile);
    }

    public String toString() {
        return "ModJarMetadata[modFile=" + this.modFile + "]";
    }
}

