/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public record VersionInfo(String forgeVersion, String mcVersion, String mcpVersion, String forgeGroup) {
    private static Gson GSON = new GsonBuilder().create();

    public String mcAndForgeVersion() {
        return this.mcVersion + "-" + this.forgeVersion;
    }

    public String mcAndMCPVersion() {
        return this.mcVersion + "-" + this.mcpVersion;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T> T readJson(String path, Class<T> type) {
        try (InputStream is = VersionInfo.class.getResourceAsStream(path);){
            Object object;
            if (is == null) {
                T t = null;
                return t;
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                object = GSON.fromJson((Reader)reader, type);
            }
            return (T)object;
        }
        catch (JsonSyntaxException | IOException e) {
            throw new IllegalStateException("Failed to parse version info from " + path, e);
        }
    }

    static VersionInfo detect() {
        JSON forge = VersionInfo.readJson("/forge_version.json", JSON.class);
        if (forge == null) {
            throw new IllegalStateException("Failed to find /forge_version.json This is a critical issue");
        }
        return new VersionInfo(forge.forge(), forge.mc(), forge.mcp(), "net.minecraftforge");
    }

    private record JSON(String forge, String mcp, String mc) {
    }
}

