/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class ForgeProdLaunchHandler
extends CommonLaunchHandler {
    protected ForgeProdLaunchHandler(CommonLaunchHandler.LaunchType type) {
        super(type, "forge_");
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    protected Path mvn(VersionInfo info, String artifact) {
        return this.mvn(info, artifact, "");
    }

    protected Path mvn(VersionInfo info, String artifact, String classifier) {
        return this.mvn(info.forgeGroup(), artifact, classifier, info.mcAndForgeVersion());
    }

    protected Path mvn(String group, String artifact, String classifier, String version) {
        return LibraryFinder.findPathForMaven(group, artifact, "", classifier, version);
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        List<Path> mc = this.getMCPaths(vers);
        Path forgejar = this.mvn(vers, "forge", "universal");
        Path fmlcore = this.mvn(vers, "fmlcore");
        Path javafmllang = this.mvn(vers, "javafmllanguage");
        Path lowcodelang = this.mvn(vers, "lowcodelanguage");
        Path mclang = this.mvn(vers, "mclanguage");
        return new CommonLaunchHandler.LocatedPaths(mc, null, List.of(List.of(forgejar)), List.of(fmlcore, javafmllang, lowcodelang, mclang));
    }

    protected abstract List<Path> getMCPaths(VersionInfo var1);

    public static class Server
    extends ForgeProdLaunchHandler {
        public Server() {
            super(SERVER);
        }

        @Override
        protected List<Path> getMCPaths(VersionInfo vers) {
            Path mc = this.mvn("net.minecraft", "server", "srg", vers.mcAndMCPVersion());
            Path mcextra = this.mvn("net.minecraft", "server", "extra", vers.mcAndMCPVersion());
            Path patches = this.mvn(vers, "forge", "server");
            BiPredicate<String, String> filter = (path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/");
            mcextra = SecureJar.from(filter, (Path[])new Path[]{mcextra}).getRootPath();
            return List.of(mc, mcextra, patches);
        }
    }

    public static class Client
    extends ForgeProdLaunchHandler {
        public Client() {
            super(CLIENT);
        }

        @Override
        protected List<Path> getMCPaths(VersionInfo vers) {
            Path mc = this.mvn("net.minecraft", "client", "srg", vers.mcAndMCPVersion());
            Path mcextra = this.mvn("net.minecraft", "client", "extra", vers.mcAndMCPVersion());
            Path patches = this.mvn(vers, "forge", "client");
            return List.of(mc, mcextra, patches);
        }
    }
}

