/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.base.Strings;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URL;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.artifact.versioning.VersionRange;

public class ModFileInfo
implements IModFileInfo,
IConfigurable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IConfigurable config;
    private final ModFile modFile;
    private final URL issueURL;
    private final List<IModFileInfo.LanguageSpec> languageSpecs;
    private final boolean showAsResourcePack;
    private final List<IModInfo> mods;
    private final Map<String, Object> properties;
    private final String license;
    private final List<String> usesServices;
    public static final String CLIENT_SIDE_ONLY_PROP = "__FORGE_clientSideOnly";
    private static final Map<String, Object> CLIENT_SIDE_ONLY_MAP = Map.of("__FORGE_clientSideOnly", Boolean.TRUE);

    ModFileInfo(ModFile modFile, IConfigurable config) {
        this.modFile = modFile;
        this.config = config;
        String modLoader = (String)config.getConfigElement(new String[]{"modLoader"}).orElseThrow(() -> new InvalidModFileException("Missing ModLoader in file", this));
        VersionRange modLoaderVersion = config.getConfigElement(new String[]{"loaderVersion"}).map(MavenVersionAdapter::createFromVersionSpec).orElseThrow(() -> new InvalidModFileException("Missing ModLoader version in file", this));
        this.languageSpecs = new ArrayList<IModFileInfo.LanguageSpec>(List.of(new IModFileInfo.LanguageSpec(modLoader, modLoaderVersion)));
        this.license = config.getConfigElement(new String[]{"license"}).orElse("");
        this.showAsResourcePack = config.getConfigElement(new String[]{"showAsResourcePack"}).orElse(false);
        boolean clientSideOnly = config.getConfigElement(new String[]{"clientSideOnly"}).orElse(false);
        this.usesServices = config.getConfigElement(new String[]{"services"}).orElse(List.of());
        Optional maybeProps = config.getConfigElement(new String[]{"properties"});
        if (clientSideOnly) {
            if (maybeProps.isPresent()) {
                this.properties = new HashMap<String, Object>((Map)maybeProps.get());
                this.properties.put(CLIENT_SIDE_ONLY_PROP, Boolean.TRUE);
            } else {
                this.properties = CLIENT_SIDE_ONLY_MAP;
            }
        } else {
            this.properties = maybeProps.orElse(Collections.emptyMap());
        }
        this.modFile.setFileProperties(this.properties);
        this.issueURL = config.getConfigElement(new String[]{"issueTrackerURL"}).map(StringUtils::toURL).orElse(null);
        List modConfigs = config.getConfigList(new String[]{"mods"});
        if (modConfigs.isEmpty()) {
            throw new InvalidModFileException("Missing mods list", this);
        }
        this.mods = modConfigs.stream().map(mi -> new ModInfo(this, (IConfigurable)mi)).collect(Collectors.toList());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.modFile::getFileName;
        supplierArray[1] = () -> this.mods.stream().map(IModInfo::getModId).collect(Collectors.joining(",", "{", "}"));
        supplierArray[2] = () -> this.mods.stream().map(IModInfo::getVersion).map(Objects::toString).collect(Collectors.joining(",", "{", "}"));
        LOGGER.debug(LogMarkers.LOADING, "Found valid mod file {} with {} mods - versions {}", supplierArray);
    }

    public ModFileInfo(ModFile file, IConfigurable config, List<IModFileInfo.LanguageSpec> languageSpecs) {
        this(file, config);
        this.languageSpecs.addAll(languageSpecs);
    }

    public List<IModInfo> getMods() {
        return this.mods;
    }

    public ModFile getFile() {
        return this.modFile;
    }

    public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
        return this.languageSpecs;
    }

    public Map<String, Object> getFileProperties() {
        return this.properties;
    }

    public boolean showAsResourcePack() {
        return this.showAsResourcePack;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return this.config.getConfigList(key);
    }

    public String getLicense() {
        return this.license;
    }

    public IConfigurable getConfig() {
        return this;
    }

    public URL getIssueURL() {
        return this.issueURL;
    }

    public boolean missingLicense() {
        return Strings.isNullOrEmpty((String)this.license);
    }

    public Optional<String> getCodeSigningFingerprint() {
        CodeSigner[] signers = this.modFile.getSecureJar().getManifestSigners();
        return (signers == null ? Stream.of(new CodeSigner[0]) : Arrays.stream(signers)).flatMap(csa -> csa.getSignerCertPath().getCertificates().stream()).findFirst().map(LamdbaExceptionUtils.rethrowFunction(Certificate::getEncoded)).map(bytes -> ((MessageDigest)LamdbaExceptionUtils.uncheck(() -> MessageDigest.getInstance("SHA-256"))).digest((byte[])bytes)).map(StringUtils::binToHex).map(str -> String.join((CharSequence)":", str.split("(?<=\\G.{2})")));
    }

    public Optional<String> getTrustData() {
        return Arrays.stream(this.modFile.getSecureJar().getManifestSigners()).flatMap(csa -> csa.getSignerCertPath().getCertificates().stream()).findFirst().map(X509Certificate.class::cast).map(c -> {
            StringBuffer sb = new StringBuffer();
            sb.append(c.getSubjectX500Principal().getName("RFC2253").split(",")[0]);
            boolean selfSigned = false;
            try {
                c.verify(c.getPublicKey());
                selfSigned = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {
                // empty catch block
            }
            if (selfSigned) {
                sb.append(" self-signed");
            } else {
                sb.append(" signed by ").append(c.getIssuerX500Principal().getName("RFC2253").split(",")[0]);
            }
            return sb.toString();
        });
    }

    public String moduleName() {
        return this.getMods().get(0).getModId();
    }

    public String versionString() {
        return this.getMods().get(0).getVersion().toString();
    }

    public List<String> usesServices() {
        return this.usesServices;
    }
}

