/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServiceLoader<IModLocator> modLocators;
    private final List<IModLocator> modLocatorList;

    public ModDiscoverer(Map<String, ?> arguments) {
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODDIRECTORYFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get(), v -> StartupMessageManager.locatorConsumer().orElseGet(() -> s -> {}));
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
        this.modLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IModLocator.class);
        this.modLocatorList = ServiceLoaderUtils.streamServiceLoader(() -> this.modLocators, sce -> LOGGER.error("Failed to load mod locator list", (Throwable)sce)).collect(Collectors.toList());
        this.modLocatorList.forEach(l -> l.initArguments(arguments));
        if (LOGGER.isDebugEnabled(LogMarkers.CORE)) {
            LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", (Object)this.modLocatorList.stream().map(modLocator -> "(%s:%s)".formatted(modLocator.name(), modLocator.getClass().getPackage().getImplementationVersion())).collect(Collectors.joining(",")));
        }
    }

    public ModValidator discoverMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)this.modLocatorList.size());
        List<ModFile> loadedFiles = new ArrayList<ModFile>();
        ArrayList<EarlyLoadingException.ExceptionData> discoveryErrorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        boolean successfullyLoadedMods = true;
        boolean distIsDedicatedServer = FMLLoader.getDist().isDedicatedServer();
        for (IModLocator locator : this.modLocatorList) {
            try {
                List<IModFile> clientOnlyModFiles;
                LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                List locatedFiles = locator.scanMods();
                List<IModFile> badModFiles = locatedFiles.stream().filter(file -> !(file instanceof ModFile)).toList();
                if (!badModFiles.isEmpty()) {
                    LOGGER.error(LogMarkers.SCAN, "Locator {} returned {} files which is are not ModFile instances! They will be skipped!", (Object)locator, (Object)badModFiles.size());
                    locatedFiles.removeAll(badModFiles);
                }
                if (distIsDedicatedServer && !(clientOnlyModFiles = locatedFiles.stream().filter(file -> {
                    IModFileInfo info = file.getModFileInfo();
                    return info != null && info.getFileProperties().getOrDefault("__FORGE_clientSideOnly", Boolean.FALSE) != false;
                }).toList()).isEmpty()) {
                    LOGGER.warn(LogMarkers.SCAN, "Locator {} returned {} files which are client-side-only mods, but we're on a dedicated server. They will be skipped!", (Object)locator, (Object)clientOnlyModFiles.size());
                    locatedFiles.removeAll(clientOnlyModFiles);
                }
                LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} valid mod files", (Object)locator, (Object)locatedFiles.size());
                this.handleLocatedFiles(loadedFiles, locatedFiles);
            }
            catch (InvalidModFileException imfe) {
                LOGGER.error(LogMarkers.SCAN, "Locator {} found an invalid mod file {}", (Object)locator, (Object)imfe.getBrokenFile(), (Object)imfe);
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to load mods with locator {}", (Object)locator, (Object)exception);
                discoveryErrorData.addAll(exception.getAllData());
            }
        }
        Map<Object, Object> modFilesMap = Maps.newHashMap();
        try {
            UniqueModListBuilder modsUniqueListBuilder = new UniqueModListBuilder(loadedFiles);
            UniqueModListBuilder.UniqueModListData uniqueModsData = modsUniqueListBuilder.buildUniqueList();
            modFilesMap = uniqueModsData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType));
            loadedFiles = uniqueModsData.modFiles();
        }
        catch (EarlyLoadingException exception) {
            LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after mod discovery.", (Throwable)exception);
            discoveryErrorData.addAll(exception.getAllData());
            successfullyLoadedMods = false;
        }
        if (successfullyLoadedMods) {
            LOGGER.debug(LogMarkers.SCAN, "Successfully Loaded {} mods. Attempting to load dependencies...", (Object)loadedFiles.size());
            for (IModLocator locator : this.modLocatorList) {
                try {
                    LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                    ImmutableList locatedMods = ImmutableList.copyOf(loadedFiles);
                    List locatedFiles = locator.scanMods((Iterable)locatedMods);
                    if (locatedFiles.stream().anyMatch(file -> !(file instanceof ModFile))) {
                        LOGGER.error(LogMarkers.SCAN, "A dependency locator returned a file which is not a ModFile instance!. They will be skipped!");
                    }
                    this.handleLocatedFiles(loadedFiles, locatedFiles);
                }
                catch (EarlyLoadingException exception) {
                    LOGGER.error(LogMarkers.SCAN, "Failed to load dependencies with locator {}", (Object)locator, (Object)exception);
                    discoveryErrorData.addAll(exception.getAllData());
                }
            }
            try {
                UniqueModListBuilder modsAndDependenciesUniqueListBuilder = new UniqueModListBuilder(loadedFiles);
                UniqueModListBuilder.UniqueModListData uniqueModsAndDependenciesData = modsAndDependenciesUniqueListBuilder.buildUniqueList();
                modFilesMap = uniqueModsAndDependenciesData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType));
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after dependency discovery.", (Throwable)exception);
                discoveryErrorData.addAll(exception.getAllData());
                modFilesMap = loadedFiles.stream().collect(Collectors.groupingBy(IModFile::getType));
            }
        } else {
            LOGGER.error(LogMarkers.SCAN, "Mod Discovery failed. Skipping dependency discovery.");
        }
        ModValidator validator = new ModValidator(modFilesMap, discoveryErrorData);
        validator.stage1Validation();
        return validator;
    }

    private void handleLocatedFiles(List<ModFile> loadedFiles, List<IModFile> locatedFiles) {
        List<ModFile> locatedModFiles = locatedFiles.stream().filter(ModFile.class::isInstance).map(ModFile.class::cast).toList();
        for (IModFile iModFile : locatedModFiles) {
            LOGGER.info(LogMarkers.SCAN, "Found mod file {} of type {} with provider {}", (Object)iModFile.getFileName(), (Object)iModFile.getType(), (Object)iModFile.getLocator());
            StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Found mod file " + mf.getFileName() + " of type " + String.valueOf(mf.getType())));
        }
        loadedFiles.addAll(locatedModFiles);
    }
}

