/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileDependencyLocator;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.jarjar.selection.JarSelector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;

public class JarInJarDependencyLocator
extends AbstractJarFileDependencyLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "JarInJar";
    }

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList sources = Lists.newArrayList();
        loadedMods.forEach(sources::add);
        List dependenciesToLoad = JarSelector.detectAndSelect((List)sources, this::loadResourceFromModFile, this::loadModFileFrom, this::identifyMod, this::exception);
        if (dependenciesToLoad.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
            return Collections.emptyList();
        }
        LOGGER.info("Found {} dependencies adding them to mods collection", (Object)dependenciesToLoad.size());
        return dependenciesToLoad;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    @Override
    protected String getDefaultJarModType() {
        return IModFile.Type.GAMELIBRARY.name();
    }

    @Override
    protected Optional<IModFile> loadModFileFrom(IModFile file, Path path) {
        try {
            Path pathInModFile = file.findResource(new String[]{path.toString()});
            URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
            ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
            FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
            Path pathInFS = zipFS.getPath("/", new String[0]);
            IModFile.Type parentType = file.getType();
            String modType = parentType == IModFile.Type.LIBRARY || parentType == IModFile.Type.LANGPROVIDER ? IModFile.Type.LIBRARY.name() : IModFile.Type.GAMELIBRARY.name();
            return this.createMod(modType, pathInFS);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mod file {} from {}", (Object)path, (Object)file.getFileName());
            throw new RuntimeException("Failed to load mod file " + file.getFileName(), e);
        }
    }

    protected EarlyLoadingException exception(Collection<JarSelector.ResolutionFailureInformation<IModFile>> failedDependencies) {
        List<EarlyLoadingException.ExceptionData> errors = failedDependencies.stream().filter(entry -> !entry.sources().isEmpty()).map(this::buildExceptionData).toList();
        return new EarlyLoadingException(failedDependencies.size() + " Dependency restrictions were not met.", null, errors);
    }

    @NotNull
    private EarlyLoadingException.ExceptionData buildExceptionData(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return new EarlyLoadingException.ExceptionData(this.getErrorTranslationKey(entry), entry.identifier().group() + ":" + entry.identifier().artifact(), entry.sources().stream().flatMap(this::getModWithVersionRangeStream).map(this::formatError).collect(Collectors.joining(", ")));
    }

    @NotNull
    private String getErrorTranslationKey(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return entry.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.dependencyloading.conflictingdependencies" : "fml.dependencyloading.mismatchedcontaineddependencies";
    }

    @NotNull
    private Stream<ModWithVersionRange> getModWithVersionRangeStream(JarSelector.SourceWithRequestedVersionRange<IModFile> file) {
        return file.sources().stream().map(IModFile::getModFileInfo).flatMap(modFileInfo -> modFileInfo.getMods().stream()).map(modInfo -> new ModWithVersionRange((IModInfo)modInfo, file.requestedVersionRange(), file.includedVersion()));
    }

    @NotNull
    private String formatError(ModWithVersionRange modWithVersionRange) {
        return "\u00a7e" + modWithVersionRange.modInfo().getModId() + "\u00a7r - \u00a74" + modWithVersionRange.versionRange().toString() + "\u00a74 - \u00a72" + modWithVersionRange.artifactVersion().toString() + "\u00a72";
    }

    @Override
    protected String identifyMod(IModFile modFile) {
        if (modFile.getModFileInfo() == null || modFile.getModInfos().isEmpty()) {
            return modFile.getFileName();
        }
        return modFile.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining());
    }

    private record ModWithVersionRange(IModInfo modInfo, VersionRange versionRange, ArtifactVersion artifactVersion) {
    }
}

