/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.IModStateProvider;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingState;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;

public class ModStateManager {
    private final EnumMap<ModLoadingPhase, List<IModLoadingState>> stateMap;

    public ModStateManager() {
        ServiceLoader<IModStateProvider> sp = ServiceLoader.load(FMLLoader.getGameLayer(), IModStateProvider.class);
        this.stateMap = ServiceLoaderUtils.streamWithErrorHandling(sp, sce -> {}).map(IModStateProvider::getAllStates).flatMap(Collection::stream).collect(Collectors.groupingBy(IModLoadingState::phase, () -> new EnumMap(ModLoadingPhase.class), Collectors.toUnmodifiableList()));
    }

    public List<IModLoadingState> getStates(ModLoadingPhase phase) {
        List<IModLoadingState> nodes = this.stateMap.get((Object)phase);
        Map lookup = nodes.stream().collect(Collectors.toMap(IModLoadingState::name, Function.identity()));
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        ModLoadingState dummy = ModLoadingState.empty("", "", phase);
        nodes.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        graph.addNode((Object)dummy);
        for (IModLoadingState node : nodes) {
            graph.putEdge((Object)lookup.getOrDefault(node.previous(), dummy), (Object)node);
        }
        return TopologicalSort.topologicalSort((Graph)graph, Comparator.comparingInt(nodes::indexOf)).stream().filter(st -> st != dummy).toList();
    }

    public IModLoadingState findState(String stateName) {
        return this.stateMap.values().stream().flatMap(Collection::stream).filter(mls -> mls.name().equals(stateName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown IModLoadingState: " + stateName));
    }
}

