/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeferredWorkQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ModLoadingStage, DeferredWorkQueue> workQueues = new HashMap<ModLoadingStage, DeferredWorkQueue>();
    private final ConcurrentLinkedDeque<TaskInfo> tasks = new ConcurrentLinkedDeque();
    private final ModLoadingStage modLoadingStage;

    public DeferredWorkQueue(ModLoadingStage modLoadingStage) {
        this.modLoadingStage = modLoadingStage;
        workQueues.put(modLoadingStage, this);
    }

    public static Optional<DeferredWorkQueue> lookup(Optional<ModLoadingStage> parallelClass) {
        return Optional.ofNullable(workQueues.get(parallelClass.orElse(null)));
    }

    public void runTasks() {
        if (this.tasks.isEmpty()) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Dispatching synchronous work for work queue {}: {} jobs", (Object)this.modLoadingStage, (Object)this.tasks.size());
        Stopwatch timer = Stopwatch.createStarted();
        this.tasks.forEach(t -> DeferredWorkQueue.makeRunnable(t, Runnable::run));
        timer.stop();
        LOGGER.debug(Logging.LOADING, "Synchronous work queue completed in {}", (Object)timer);
    }

    private static void makeRunnable(TaskInfo ti, Executor executor) {
        executor.execute(() -> {
            Stopwatch timer = Stopwatch.createStarted();
            ModLoadingContext.get().setActiveContainer(ti.owner);
            try {
                ti.task.run();
            }
            finally {
                ModLoadingContext.get().setActiveContainer(null);
            }
            timer.stop();
            if (timer.elapsed(TimeUnit.SECONDS) >= 1L) {
                LOGGER.warn(Logging.LOADING, "Mod '{}' took {} to run a deferred task.", (Object)ti.owner.getModId(), (Object)timer);
            }
        });
    }

    public CompletableFuture<Void> enqueueWork(ModContainer modInfo, Runnable work) {
        return CompletableFuture.runAsync(work, r -> this.tasks.add(new TaskInfo(modInfo, r)));
    }

    public <T> CompletableFuture<T> enqueueWork(ModContainer modInfo, Supplier<T> work) {
        return CompletableFuture.supplyAsync(work, r -> this.tasks.add(new TaskInfo(modInfo, r)));
    }

    record TaskInfo(ModContainer owner, Runnable task) {
    }
}

