/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.bootstrap;

import cpw.mods.jarhandling.SecureJar;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import net.minecraftforge.bootstrap.Bootstrap;

public class ForgeBootstrap
extends Bootstrap {
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String MINECRAFT = "net/minecraft/client/main/Main.class";
    private static final Attributes.Name MOD_TYPE = new Attributes.Name("FMLModType");

    public static void main(String[] args) throws Exception {
        new ForgeBootstrap().start(args);
    }

    @Override
    protected List<SecureJar> selectRuntimeModules(List<SecureJar> classpath) {
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        int width = classpath.stream().mapToInt(p -> p.moduleDataProvider().name().length()).max().orElse(0) + 1;
        if (DEBUG) {
            ForgeBootstrap.log("Found classpath:");
        }
        for (SecureJar securejar : classpath) {
            SecureJar.ModuleDataProvider meta = securejar.moduleDataProvider();
            if (meta.findFile(MODS_TOML).isPresent() || meta.findFile(MINECRAFT).isPresent() || meta.getManifest().getMainAttributes().getValue(MOD_TYPE) != null) {
                if (!DEBUG) continue;
                ForgeBootstrap.log("  ModFile:   " + ForgeBootstrap.pad(width, meta.name()) + securejar.getPrimaryPath());
                continue;
            }
            if (bootlayer.findModule(meta.name()).isEmpty()) {
                if (DEBUG) {
                    ForgeBootstrap.log("  Module:    " + ForgeBootstrap.pad(width, meta.name()) + securejar.getPrimaryPath());
                }
                ret.add(securejar);
                continue;
            }
            if (!DEBUG) continue;
            ForgeBootstrap.log("  Bootstrap: " + ForgeBootstrap.pad(width, meta.name()) + securejar.getPrimaryPath());
        }
        return ret;
    }

    private static String pad(int width, String str) {
        return str + " ".repeat(width - str.length());
    }
}

