/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.bootstrap;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.SimpleJarMetadata;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.bootstrap.Bootstrap;
import net.minecraftforge.bootstrap.ForgeBootstrap;

class ClassPathHelper {
    private static final boolean DEBUG = ForgeBootstrap.DEBUG;
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");
    private static final Attributes.Name FORGE_MODULE_LAYER = new Attributes.Name("Forge-Module-Layer");
    private static final String VERSION_DIR = "META-INF/versions/";
    private static final String IGNORE = "META-INF/forge-bootstrap-ignore";
    private static final String MODULE_INFO = "module-info.class";
    private static List<SecureJar> cache = null;

    ClassPathHelper() {
    }

    public static List<SecureJar> getCleanedClassPath() {
        if (cache == null) {
            try {
                cache = ClassPathHelper.getCleanedClassPathImpl();
            }
            catch (IOException e) {
                ClassPathHelper.sneak(e);
            }
        }
        return cache;
    }

    private static List<SecureJar> getCleanedClassPathImpl() throws IOException {
        HashMap<String, Map> sourcesets = new HashMap<String, Map>();
        TreeMap<String, ModuleInfo> modules = new TreeMap<String, ModuleInfo>();
        List<Path> classpath = ClassPathHelper.findAllClassPathEntries();
        for (Path path2 : classpath) {
            if (Files.isDirectory(path2, new LinkOption[0])) {
                List lst;
                String prj = null;
                String sourceset = path2.getFileName().toString();
                if ("default".equals(sourceset)) continue;
                if ("bin".equals(ClassPathHelper.getParent(1, path2))) {
                    prj = ClassPathHelper.getProjectName(2, path2);
                } else if ("resources".equals(ClassPathHelper.getParent(1, path2))) {
                    prj = ClassPathHelper.getProjectName(3, path2);
                } else if ("classes".equals(ClassPathHelper.getParent(2, path2))) {
                    prj = ClassPathHelper.getProjectName(4, path2);
                }
                if (prj == null || sourceset == null || (lst = sourcesets.computeIfAbsent(prj, n -> new HashMap()).computeIfAbsent(sourceset, n -> new ArrayList())).contains(path2)) continue;
                lst.add(path2);
                continue;
            }
            ModuleVersion module = ClassPathHelper.findModuleName(path2, null);
            if (module.name() == null) {
                SimpleJarMetadata meta = JarMetadata.fromFileName((Path)path2, Set.of(), List.of());
                module = new ModuleVersion(meta.name(), meta.version(), module.layer());
            }
            ModuleInfo info = modules.computeIfAbsent(module.name(), k -> new ModuleInfo());
            info.paths.add(path2);
            if (info.version != null) continue;
            info.version = module.version();
        }
        for (String prj : sourcesets.keySet()) {
            Map sources = (Map)sourcesets.get(prj);
            for (String source : sources.keySet()) {
                List dirs = (List)sources.get(source);
                ModuleVersion module = ClassPathHelper.findModuleName(dirs);
                if (module == null) {
                    if (!DEBUG) continue;
                    for (int x = 0; x < dirs.size(); ++x) {
                        if (x == 0) {
                            Bootstrap.log("Non Module: " + dirs.get(x));
                            continue;
                        }
                        Bootstrap.log("            " + dirs.get(x));
                    }
                    continue;
                }
                ModuleInfo info = (ModuleInfo)modules.get(module.name());
                if (info != null) {
                    if (DEBUG) {
                        int x;
                        Bootstrap.log("Overriding: " + module.name());
                        for (x = 0; x < info.paths.size(); ++x) {
                            if (x == 0) {
                                Bootstrap.log("       Old: " + info.paths.get(x));
                                continue;
                            }
                            Bootstrap.log("            " + info.paths.get(x));
                        }
                        for (x = 0; x < dirs.size(); ++x) {
                            if (x == 0) {
                                Bootstrap.log("       New: " + dirs.get(x));
                                continue;
                            }
                            Bootstrap.log("            " + dirs.get(x));
                        }
                    }
                    info.paths.clear();
                    info.paths.addAll(dirs);
                    if (info.version != null) continue;
                    info.version = module.version();
                    continue;
                }
                if (!"boot".equals(module.layer())) continue;
                if (DEBUG) {
                    Bootstrap.log("Forced:     " + module.name());
                    dirs.forEach(path -> Bootstrap.log("            " + path));
                }
                info = new ModuleInfo();
                info.paths.addAll(dirs);
                info.version = module.version();
                modules.put(module.name(), info);
            }
        }
        TreeMap<String, SecureJar> jars = new TreeMap<String, SecureJar>();
        for (ModuleInfo info : modules.values()) {
            ArrayList paths = new ArrayList(info.paths.size());
            info.paths.forEach(paths::add);
            Collections.reverse(paths);
            SecureJar securejar = SecureJar.from(jar -> ClassPathHelper.getMetadata(jar, info), (Path[])((Path[])paths.stream().toArray(Path[]::new)));
            jars.put(securejar.moduleDataProvider().name(), securejar);
        }
        for (SecureJar jar2 : List.copyOf(jars.values())) {
            Path ignore = jar2.getPath(IGNORE, new String[0]);
            if (!Files.exists(ignore, new LinkOption[0])) continue;
            if (DEBUG) {
                Bootstrap.log("Ingore File: " + ignore);
            }
            ArrayList<String> ignores = new ArrayList<String>();
            for (String line : Files.readAllLines(ignore, StandardCharsets.UTF_8)) {
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((line = line.trim()).isEmpty()) continue;
                ignores.add(line);
            }
            if (ignores.isEmpty()) {
                ignores.add(jar2.moduleDataProvider().name());
            }
            for (String line : ignores) {
                if (DEBUG) {
                    Bootstrap.log("\tIgnoring: " + line);
                }
                jars.remove(line);
            }
        }
        cache = List.copyOf(jars.values());
        return cache;
    }

    private static List<Path> findAllClassPathEntries() throws IOException {
        String[] parts = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String part : parts) {
            Path path = new File(part).getCanonicalFile().toPath();
            if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && Files.list(path).findAny().isEmpty()) continue;
            paths.add(path);
        }
        return paths;
    }

    private static String getParent(int levels, Path path) {
        Path parent = path;
        for (int x = 0; x < levels; ++x) {
            if ((parent = parent.getParent()) != null) continue;
            return null;
        }
        return parent == null ? null : parent.getFileName().toString();
    }

    private static String getProjectName(int levels, Path path) {
        String name = ClassPathHelper.getParent(levels, path);
        if (name != null) {
            return name;
        }
        if (DEBUG) {
            Bootstrap.log("Invalid directory path: " + path);
        }
        return "default";
    }

    private static ModuleVersion findModuleName(Collection<Path> paths) throws IOException {
        for (Path path : paths) {
            ModuleVersion ret = ClassPathHelper.findModuleName(path, null);
            if (ret.name == null) continue;
            return ret;
        }
        return null;
    }

    private static ModuleVersion findModuleName(Path path, String _default) throws IOException {
        Manifest mf = null;
        record InfoData(int version, byte[] data) {
        }
        ArrayList<InfoData> infos = new ArrayList<InfoData>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Path manifest = Files.walk(path, new FileVisitOption[0]).filter(p -> "META-INF/MANIFEST.MF".equalsIgnoreCase(path.relativize((Path)p).toString().replace('\\', '/'))).findFirst().orElse(null);
            if (manifest != null && Files.exists(manifest, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(manifest, new OpenOption[0]);){
                    mf = new Manifest(is);
                }
            }
            List<Path> paths = Files.walk(path, new FileVisitOption[0]).filter(p -> p.toString().endsWith(MODULE_INFO)).toList();
            for (Path p2 : paths) {
                String relative = path.relativize(p2).toString().replace('\\', '/');
                int version = 0;
                if (relative.startsWith(VERSION_DIR)) {
                    int idx = relative.indexOf(47, VERSION_DIR.length());
                    String ver = relative.substring(VERSION_DIR.length(), idx);
                    version = Integer.parseInt(ver);
                }
                infos.add(new InfoData(version, Files.readAllBytes(p2)));
            }
        } else {
            try (ZipInputStream zip = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    String name = entry.getName();
                    if ("META-INF/MANIFEST.MF".equalsIgnoreCase(name)) {
                        mf = new Manifest(zip);
                        continue;
                    }
                    if (!name.endsWith(MODULE_INFO)) continue;
                    int version = 0;
                    if (name.startsWith(VERSION_DIR)) {
                        int idx = name.indexOf(47, VERSION_DIR.length());
                        String ver = name.substring(VERSION_DIR.length(), idx);
                        version = Integer.parseInt(ver);
                    }
                    infos.add(new InfoData(version, zip.readAllBytes()));
                }
            }
        }
        InfoData info = null;
        info = mf != null && Boolean.parseBoolean(mf.getMainAttributes().getValue(MULTI_RELEASE)) ? (InfoData)infos.stream().sorted((a, b) -> b.version - a.version).filter(a -> a.version <= Runtime.version().feature()).findFirst().orElse(null) : (InfoData)infos.stream().filter(i -> i.version == 0).findFirst().orElse(null);
        String name = _default;
        String version = null;
        String layer = null;
        if (mf != null) {
            name = mf.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME);
            layer = mf.getMainAttributes().getValue(FORGE_MODULE_LAYER);
        }
        if (info != null) {
            ModuleDescriptor desc = ModuleDescriptor.read(new ByteArrayInputStream(info.data));
            name = desc.name();
            version = desc.version().map(Object::toString).orElse(null);
        }
        return new ModuleVersion(name, version, layer);
    }

    private static JarMetadata getMetadata(SecureJar jar, ModuleInfo info) {
        JarMetadata ret = JarMetadata.from((SecureJar)jar, (Path[])new Path[]{jar.getPrimaryPath()});
        return ret;
    }

    private static <E extends Throwable, R> R sneak(Exception exception) throws E {
        throw exception;
    }

    private record ModuleVersion(String name, String version, String layer) {
    }

    private static class ModuleInfo {
        private final List<Path> paths = new ArrayList<Path>();
        private String version;

        private ModuleInfo() {
        }
    }
}

