/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.bootstrap;

import cpw.mods.jarhandling.SecureJar;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.bootstrap.ClassPathHelper;
import net.minecraftforge.bootstrap.api.BootstrapEntryPoint;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import net.minecraftforge.securemodules.SecureModuleFinder;
import net.minecraftforge.unsafe.UnsafeHacks;

public class Bootstrap {
    static final boolean DEBUG = Boolean.getBoolean("bsl.debug");

    static void log(String message) {
        System.out.println(message);
    }

    protected void start(String ... args) throws Exception {
        List<SecureJar> boot = this.selectBootModules(ClassPathHelper.getCleanedClassPath());
        SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])boot.toArray(SecureJar[]::new)));
        List<String> targets = boot.stream().map(SecureJar::name).toList();
        Configuration cfg = ModuleLayer.boot().configuration().resolve((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ModuleLayer layer = ModuleLayer.boot().defineModulesWithOneLoader(cfg, cl);
        Module bootstrap = layer.findModule("net.minecraftforge.bootstrap").get();
        ClassLoader moduleCl = bootstrap.getClassLoader();
        Class<?> self = Class.forName(this.getClass().getName(), false, moduleCl);
        Object inst = self.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method moduleMain = Bootstrap.findMethod(self, "moduleMain", String[].class);
        if (moduleMain == null) {
            throw new IllegalStateException("Could not find \"moduleMain(String[])\" on " + self.getName());
        }
        UnsafeHacks.setAccessible((AccessibleObject)moduleMain);
        moduleMain.invoke(inst, new Object[]{args});
    }

    protected List<SecureJar> selectBootModules(List<SecureJar> classpath) {
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        Set<String> bootLibraries = Set.of("cpw.mods.securejarhandler", "net.minecraftforge.unsafe", "net.minecraftforge.bootstrap", "net.minecraftforge.bootstrap.api", "org.objectweb.asm", "org.objectweb.asm.tree");
        for (SecureJar securejar : classpath) {
            if (!bootLibraries.contains(securejar.moduleDataProvider().name())) continue;
            ret.add(securejar);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moduleMain(String ... args) throws Exception {
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        List<SecureJar> secure = this.selectRuntimeModules(ClassPathHelper.getCleanedClassPath());
        SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])secure.toArray(SecureJar[]::new)));
        List<String> targets = secure.stream().map(SecureJar::name).toList();
        Configuration cfg = bootlayer.configuration().resolveAndBind((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
        List<ModuleLayer> parent = List.of(ModuleLayer.boot(), bootlayer);
        SecureModuleClassLoader cl = new SecureModuleClassLoader("SECURE-BOOTSTRAP", null, cfg, parent);
        ModuleLayer layer = bootlayer.defineModules(cfg, module -> cl);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            List<ServiceLoader.Provider<BootstrapEntryPoint>> services = ServiceLoader.load(layer, BootstrapEntryPoint.class).stream().toList();
            if (services.isEmpty()) {
                throw new IllegalStateException("Could not find any " + BootstrapEntryPoint.class.getName() + " service providers");
            }
            if (services.size() > 1) {
                throw new IllegalStateException("Found multiple " + BootstrapEntryPoint.class.getName() + " service providers: " + services.stream().map(p -> ((BootstrapEntryPoint)p.get()).name()).collect(Collectors.joining(", ")));
            }
            BootstrapEntryPoint loader = services.get(0).get();
            if (DEBUG) {
                Bootstrap.log("Starting: " + loader.getClass().getModule().getName() + "/" + loader.name());
            }
            loader.main(args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    protected List<SecureJar> selectRuntimeModules(List<SecureJar> classpath) {
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        int width = classpath.stream().mapToInt(p -> p.moduleDataProvider().name().length()).max().orElse(0) + 1;
        if (DEBUG) {
            Bootstrap.log("Found classpath:");
        }
        for (SecureJar securejar : classpath) {
            SecureJar.ModuleDataProvider meta = securejar.moduleDataProvider();
            if (bootlayer.findModule(meta.name()).isEmpty()) {
                if (DEBUG) {
                    Bootstrap.log("  Module:    " + Bootstrap.pad(width, meta.name()) + securejar.getPrimaryPath());
                }
                ret.add(securejar);
                continue;
            }
            if (!DEBUG) continue;
            Bootstrap.log("  Bootstrap: " + Bootstrap.pad(width, meta.name()) + securejar.getPrimaryPath());
        }
        return ret;
    }

    private static String pad(int width, String str) {
        return str + " ".repeat(width - str.length());
    }

    private static Method findMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        try {
            return cls.getDeclaredMethod(name, String[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (cls.getSuperclass() != null) {
                return Bootstrap.findMethod(cls.getSuperclass(), name, parameterTypes);
            }
            return null;
        }
    }
}

