/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.skcraft.launcher.util.HttpRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class NemModList {
    private Map<String, ModEntry> mods = ImmutableMap.of();

    public void load(String version) throws IOException, InterruptedException {
        Preconditions.checkNotNull(version, "version");
        List<ModEntry> mods = HttpRequest.get(HttpRequest.url("https://bot.notenoughmods.com/" + version + ".json")).execute().expectResponseCode(200).returnContent().asJson(new TypeReference<List<ModEntry>>(){});
        HashMap<String, ModEntry> index = Maps.newHashMap();
        for (ModEntry entry : mods) {
            index.put(entry.getModId(), entry);
        }
        this.mods = Collections.unmodifiableMap(index);
    }

    @Nullable
    public ModEntry get(String modId) {
        Preconditions.checkNotNull(modId, "modId");
        return this.mods.get(modId);
    }

    public Map<String, ModEntry> getMods() {
        return this.mods;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModEntry {
        @JsonProperty(value="modid")
        private String modId;
        private String name;
        private List<String> aliases;
        @JsonProperty(value="version")
        private String latestVersion;
        @JsonProperty(value="dev")
        private String latestDevVersion;
        @JsonProperty(value="prevversion")
        private String previousVersion;
        private List<String> dependencies;
        @JsonProperty(value="longurl")
        private URL url;
        private List<String> tags;
        private String comment;
        private String author;
        private String license;
        private URL repo;
        @JsonProperty(value="added_at")
        private Date addedAt;
        @JsonProperty(value="lastupdated")
        private Date lastUpdated;

        public String getModId() {
            return this.modId;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public String getLatestVersion() {
            return this.latestVersion;
        }

        public String getLatestDevVersion() {
            return this.latestDevVersion;
        }

        public String getPreviousVersion() {
            return this.previousVersion;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public URL getUrl() {
            return this.url;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String getComment() {
            return this.comment;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLicense() {
            return this.license;
        }

        public URL getRepo() {
            return this.repo;
        }

        public Date getAddedAt() {
            return this.addedAt;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        @JsonProperty(value="modid")
        public void setModId(String modId) {
            this.modId = modId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        @JsonProperty(value="version")
        public void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @JsonProperty(value="dev")
        public void setLatestDevVersion(String latestDevVersion) {
            this.latestDevVersion = latestDevVersion;
        }

        @JsonProperty(value="prevversion")
        public void setPreviousVersion(String previousVersion) {
            this.previousVersion = previousVersion;
        }

        public void setDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        @JsonProperty(value="longurl")
        public void setUrl(URL url) {
            this.url = url;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public void setRepo(URL repo) {
            this.repo = repo;
        }

        @JsonProperty(value="added_at")
        public void setAddedAt(Date addedAt) {
            this.addedAt = addedAt;
        }

        @JsonProperty(value="lastupdated")
        public void setLastUpdated(Date lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModEntry)) {
                return false;
            }
            ModEntry other = (ModEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$modId = this.getModId();
            String other$modId = other.getModId();
            if (this$modId == null ? other$modId != null : !this$modId.equals(other$modId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$aliases = this.getAliases();
            List<String> other$aliases = other.getAliases();
            if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
                return false;
            }
            String this$latestVersion = this.getLatestVersion();
            String other$latestVersion = other.getLatestVersion();
            if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
                return false;
            }
            String this$latestDevVersion = this.getLatestDevVersion();
            String other$latestDevVersion = other.getLatestDevVersion();
            if (this$latestDevVersion == null ? other$latestDevVersion != null : !this$latestDevVersion.equals(other$latestDevVersion)) {
                return false;
            }
            String this$previousVersion = this.getPreviousVersion();
            String other$previousVersion = other.getPreviousVersion();
            if (this$previousVersion == null ? other$previousVersion != null : !this$previousVersion.equals(other$previousVersion)) {
                return false;
            }
            List<String> this$dependencies = this.getDependencies();
            List<String> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            List<String> this$tags = this.getTags();
            List<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$license = this.getLicense();
            String other$license = other.getLicense();
            if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
                return false;
            }
            URL this$repo = this.getRepo();
            URL other$repo = other.getRepo();
            if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
                return false;
            }
            Date this$addedAt = this.getAddedAt();
            Date other$addedAt = other.getAddedAt();
            if (this$addedAt == null ? other$addedAt != null : !((Object)this$addedAt).equals(other$addedAt)) {
                return false;
            }
            Date this$lastUpdated = this.getLastUpdated();
            Date other$lastUpdated = other.getLastUpdated();
            return !(this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $modId = this.getModId();
            result = result * 59 + ($modId == null ? 43 : $modId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $aliases = this.getAliases();
            result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
            String $latestVersion = this.getLatestVersion();
            result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
            String $latestDevVersion = this.getLatestDevVersion();
            result = result * 59 + ($latestDevVersion == null ? 43 : $latestDevVersion.hashCode());
            String $previousVersion = this.getPreviousVersion();
            result = result * 59 + ($previousVersion == null ? 43 : $previousVersion.hashCode());
            List<String> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            List<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $license = this.getLicense();
            result = result * 59 + ($license == null ? 43 : $license.hashCode());
            URL $repo = this.getRepo();
            result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
            Date $addedAt = this.getAddedAt();
            result = result * 59 + ($addedAt == null ? 43 : ((Object)$addedAt).hashCode());
            Date $lastUpdated = this.getLastUpdated();
            result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
            return result;
        }

        public String toString() {
            return "NemModList.ModEntry(modId=" + this.getModId() + ", name=" + this.getName() + ", aliases=" + this.getAliases() + ", latestVersion=" + this.getLatestVersion() + ", latestDevVersion=" + this.getLatestDevVersion() + ", previousVersion=" + this.getPreviousVersion() + ", dependencies=" + this.getDependencies() + ", url=" + this.getUrl() + ", tags=" + this.getTags() + ", comment=" + this.getComment() + ", author=" + this.getAuthor() + ", license=" + this.getLicense() + ", repo=" + this.getRepo() + ", addedAt=" + this.getAddedAt() + ", lastUpdated=" + this.getLastUpdated() + ")";
        }
    }
}

