/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.skcraft.launcher.creator.server.LatestHandler;
import com.skcraft.launcher.creator.server.NewsHandler;
import com.skcraft.launcher.creator.server.PackagesHandler;
import com.skcraft.launcher.creator.server.TestServer;
import java.io.File;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

public class TestServerBuilder {
    private File baseDir = new File(".");
    private int port = 28888;

    public File getBaseDir() {
        return this.baseDir;
    }

    public TestServerBuilder setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public TestServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public TestServer build() {
        Server server = new Server(this.port);
        ObjectMapper mapper = new ObjectMapper();
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setResourceBase(this.baseDir.getAbsolutePath());
        resourceHandler.setMinMemoryMappedContentLength(-1);
        ContextHandler rootContext = new ContextHandler();
        rootContext.setContextPath("/");
        rootContext.setHandler(resourceHandler);
        ContextHandler packagesContext = new ContextHandler("/packages.json");
        packagesContext.setAllowNullPathInfo(true);
        packagesContext.setHandler(new PackagesHandler(mapper, this.baseDir));
        ContextHandler latestContext = new ContextHandler("/latest.json");
        latestContext.setAllowNullPathInfo(true);
        latestContext.setHandler(new LatestHandler(mapper));
        ContextHandler newsContext = new ContextHandler("/news.html");
        newsContext.setAllowNullPathInfo(true);
        newsContext.setHandler(new NewsHandler());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{packagesContext, latestContext, newsContext, rootContext});
        GzipHandler gzip = new GzipHandler();
        server.setHandler(gzip);
        gzip.setHandler(contexts);
        server.addBean(new ErrorHandler());
        return new TestServer(server);
    }
}

