/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.model.modpack.ManifestInfo;
import com.skcraft.launcher.model.modpack.PackageList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

class PackagesHandler
extends AbstractHandler {
    private final ObjectMapper mapper;
    private final File baseDir;

    public PackagesHandler(ObjectMapper mapper, File baseDir) {
        this.mapper = mapper;
        this.baseDir = baseDir;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain; charset=utf-8");
        response.setStatus(200);
        ArrayList<ManifestInfo> packages = Lists.newArrayList();
        PackageList packageList = new PackageList();
        packageList.setPackages(packages);
        File[] files = this.baseDir.listFiles(new PackageFileFilter());
        if (files != null) {
            for (File file : files) {
                Manifest manifest = this.mapper.readValue(file, Manifest.class);
                ManifestInfo info = new ManifestInfo();
                info.setName(manifest.getName());
                info.setTitle(manifest.getTitle());
                info.setVersion(manifest.getVersion());
                info.setLocation(file.getName());
                packages.add(info);
            }
        }
        this.mapper.writeValue(response.getWriter(), (Object)packageList);
        baseRequest.setHandled(true);
    }

    private static class PackageFileFilter
    implements FileFilter {
        private PackageFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().toLowerCase().endsWith(".json");
        }
    }
}

