/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.creator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.skcraft.launcher.creator.model.creator.ManifestEntry;
import com.skcraft.launcher.creator.model.creator.Pack;
import com.skcraft.launcher.creator.model.swing.ListingType;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Workspace {
    public static final String DIR_NAME = ".modpacks";
    public static final String FILENAME = "workspace.json";
    @JsonIgnore
    private File directory;
    private List<Pack> packs = Lists.newArrayList();
    private List<ManifestEntry> packageListingEntries = Lists.newArrayList();
    private ListingType packageListingType = ListingType.STATIC;

    public void setPacks(List<Pack> packs) {
        this.packs = packs != null ? packs : Lists.newArrayList();
    }

    public void setPackageListingEntries(List<ManifestEntry> entries) {
        this.packageListingEntries = entries != null ? entries : Lists.newArrayList();
    }

    public void setPackageListingType(ListingType packageListingType) {
        this.packageListingType = packageListingType != null ? packageListingType : ListingType.STATIC;
    }

    public boolean hasPack(File dir) {
        for (Pack pack : this.packs) {
            try {
                if (!pack.getDirectory().getCanonicalPath().equals(dir.getCanonicalPath())) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public void load() {
        for (Pack pack : this.getPacks()) {
            pack.setWorkspace(this);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static File getDataDir(File workspaceDir) {
        return new File(workspaceDir, DIR_NAME);
    }

    public static File getWorkspaceFile(File workspaceDir) {
        return new File(Workspace.getDataDir(workspaceDir), FILENAME);
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<Pack> getPacks() {
        return this.packs;
    }

    public List<ManifestEntry> getPackageListingEntries() {
        return this.packageListingEntries;
    }

    public ListingType getPackageListingType() {
        return this.packageListingType;
    }

    @JsonIgnore
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String toString() {
        return "Workspace(directory=" + this.getDirectory() + ", packs=" + this.getPacks() + ", packageListingEntries=" + this.getPackageListingEntries() + ", packageListingType=" + (Object)((Object)this.getPackageListingType()) + ")";
    }
}

