/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.creator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.skcraft.launcher.builder.BuilderConfig;
import com.skcraft.launcher.creator.model.creator.Workspace;
import com.skcraft.launcher.persistence.Persistence;
import java.io.File;

public class Pack {
    private String location;
    @JsonIgnore
    private Workspace workspace;
    @JsonIgnore
    private BuilderConfig cachedConfig;

    @JsonIgnore
    public File getDirectory() {
        File path = new File(this.location);
        if (path.isAbsolute()) {
            return path;
        }
        return new File(this.workspace.getDirectory(), this.location);
    }

    @JsonIgnore
    public File getLoadersDir() {
        return new File(this.getDirectory(), "loaders");
    }

    @JsonIgnore
    public File getSourceDir() {
        return new File(this.getDirectory(), "src");
    }

    @JsonIgnore
    public File getModsDir() {
        return new File(this.getSourceDir(), "mods");
    }

    @JsonIgnore
    public File getConfigFile() {
        return new File(this.getDirectory(), "modpack.json");
    }

    public void load() {
        this.setCachedConfig(Persistence.read(this.getConfigFile(), BuilderConfig.class, true));
        this.getLoadersDir().mkdirs();
        this.getSourceDir().mkdirs();
    }

    public void createGuideFolders() {
        new File(this.getSourceDir(), "config").mkdirs();
        new File(this.getSourceDir(), "mods").mkdirs();
        new File(this.getSourceDir(), "resourcepacks").mkdirs();
    }

    @JsonIgnore
    public boolean isLoaded() {
        return this.cachedConfig != null;
    }

    public String getLocation() {
        return this.location;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public BuilderConfig getCachedConfig() {
        return this.cachedConfig;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @JsonIgnore
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @JsonIgnore
    public void setCachedConfig(BuilderConfig cachedConfig) {
        this.cachedConfig = cachedConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pack)) {
            return false;
        }
        Pack other = (Pack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Workspace this$workspace = this.getWorkspace();
        Workspace other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace)) {
            return false;
        }
        BuilderConfig this$cachedConfig = this.getCachedConfig();
        BuilderConfig other$cachedConfig = other.getCachedConfig();
        return !(this$cachedConfig == null ? other$cachedConfig != null : !((Object)this$cachedConfig).equals(other$cachedConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Workspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        BuilderConfig $cachedConfig = this.getCachedConfig();
        result = result * 59 + ($cachedConfig == null ? 43 : ((Object)$cachedConfig).hashCode());
        return result;
    }

    public String toString() {
        return "Pack(location=" + this.getLocation() + ", workspace=" + this.getWorkspace() + ", cachedConfig=" + this.getCachedConfig() + ")";
    }
}

