/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.model.creator.RecentEntry;
import com.skcraft.launcher.creator.swing.BorderCellRenderer;
import com.skcraft.launcher.swing.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class WelcomeDialog
extends JFrame {
    private final JButton newButton = new JButton("New Workspace...", SwingHelper.createIcon(Creator.class, "new.png"));
    private final JButton openButton = new JButton("Open Workspace...", SwingHelper.createIcon(Creator.class, "open_folder.png"));
    private final JButton helpButton = new JButton("Help");
    private final JButton aboutButton = new JButton("About");
    private final JButton quitButton = new JButton("Quit");
    private final JList<RecentEntry> recentList = new JList();

    public WelcomeDialog() {
        super("Modpack Creator");
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        SwingHelper.setFrameIcon(this, Creator.class, "icon.png");
    }

    private void initComponents() {
        this.recentList.setCellRenderer(new BorderCellRenderer(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets 50 20"));
        container.add((Component)new JLabel(SwingHelper.createIcon(Creator.class, "welcome_logo.png")), "wrap, gap 20 20, gapbottom 30");
        container.add((Component)this.newButton, "grow, gap 50 50, wrap");
        container.add((Component)this.openButton, "grow, gap 50 50, wrap");
        JScrollPane recentScrollPane = new JScrollPane(this.recentList);
        recentScrollPane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY));
        recentScrollPane.setVerticalScrollBarPolicy(20);
        container.add((Component)recentScrollPane, "dock east, w 280, h 390");
        JPanel buttons = new JPanel();
        buttons.setLayout(new MigLayout("insets 20", "[][]push[]"));
        buttons.add(this.helpButton);
        buttons.add(this.aboutButton);
        buttons.add(this.quitButton);
        container.add((Component)buttons, "dock south");
        this.add((Component)container, "Center");
        this.getRootPane().registerKeyboardAction(e -> this.quitButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public JButton getAboutButton() {
        return this.aboutButton;
    }

    public JButton getQuitButton() {
        return this.quitButton;
    }

    public JList<RecentEntry> getRecentList() {
        return this.recentList;
    }
}

