/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.google.common.base.Joiner;
import com.skcraft.launcher.builder.FeaturePattern;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.creator.model.swing.RecommendationComboBoxModel;
import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class FeaturePatternDialog
extends JDialog {
    private static final Joiner NEW_LINE_JOINER = Joiner.on("\n");
    private final JTextField nameText = new JTextField(20);
    private final JTextArea descArea = new JTextArea(3, 40);
    private final JComboBox recommendationCombo = new JComboBox(new RecommendationComboBoxModel());
    private final JCheckBox selectedCheck = new JCheckBox("Selected by default");
    private final JTextArea includeArea = new JTextArea(8, 40);
    private final JTextArea excludeArea = new JTextArea(3, 40);
    private final FeaturePattern pattern;
    private boolean saved = false;

    public FeaturePatternDialog(Window parent, FeaturePattern pattern) {
        super(parent, "Configure Feature", Dialog.ModalityType.DOCUMENT_MODAL);
        this.pattern = pattern;
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.copyFrom();
    }

    private void initComponents() {
        this.nameText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.descArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.includeArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.excludeArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.descArea.setFont(this.nameText.getFont());
        this.includeArea.setFont(this.nameText.getFont());
        this.excludeArea.setFont(this.nameText.getFont());
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets dialog"));
        container.add(new JLabel("Feature Name:"));
        container.add((Component)this.nameText, "span");
        container.add(new JLabel("Recommendation:"));
        container.add((Component)this.recommendationCombo, "span");
        container.add((Component)this.selectedCheck, "span");
        container.add((Component)new JLabel("Description:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.descArea), "span");
        container.add((Component)new JLabel("Include Patterns:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.includeArea), "span");
        container.add((Component)new JLabel("Exclude Patterns:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.excludeArea), "span, gapbottom unrel");
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        container.add((Component)okButton, "tag ok, span, split 2, sizegroup bttn");
        container.add((Component)cancelButton, "tag cancel, sizegroup bttn");
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(e -> cancelButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        this.add((Component)container, "Center");
        okButton.addActionListener(e -> {
            if (this.nameText.getText().trim().isEmpty()) {
                SwingHelper.showErrorDialog(this, "The 'Feature Name' field cannot be empty.", "Input Error");
                return;
            }
            if (this.descArea.getText().trim().isEmpty()) {
                SwingHelper.showErrorDialog(this, "The 'Description' field cannot be empty.", "Input Error");
                return;
            }
            if (this.includeArea.getText().trim().isEmpty()) {
                SwingHelper.showErrorDialog(this, "The 'Include Patterns' field cannot be empty.", "Input Error");
                return;
            }
            this.copyTo();
            this.saved = true;
            this.dispose();
        });
        cancelButton.addActionListener(e -> this.dispose());
    }

    private void copyFrom() {
        if (this.pattern.getFeature() == null) {
            this.pattern.setFeature(new Feature());
        }
        if (this.pattern.getFilePatterns() == null) {
            this.pattern.setFilePatterns(new FnPatternList());
        }
        SwingHelper.setTextAndResetCaret(this.nameText, this.pattern.getFeature().getName());
        SwingHelper.setTextAndResetCaret(this.descArea, this.pattern.getFeature().getDescription());
        this.recommendationCombo.setSelectedItem((Object)this.pattern.getFeature().getRecommendation());
        this.selectedCheck.setSelected(this.pattern.getFeature().isSelected());
        SwingHelper.setTextAndResetCaret(this.includeArea, NEW_LINE_JOINER.join(this.pattern.getFilePatterns().getInclude()));
        SwingHelper.setTextAndResetCaret(this.excludeArea, NEW_LINE_JOINER.join(this.pattern.getFilePatterns().getExclude()));
    }

    private void copyTo() {
        this.pattern.getFeature().setName(this.nameText.getText().trim());
        this.pattern.getFeature().setDescription(this.descArea.getText().trim());
        this.pattern.getFeature().setRecommendation((Feature.Recommendation)((Object)this.recommendationCombo.getSelectedItem()));
        this.pattern.getFeature().setSelected(this.selectedCheck.isSelected());
        this.pattern.getFilePatterns().setInclude(SwingHelper.linesToList(this.includeArea.getText()));
        this.pattern.getFilePatterns().setExclude(SwingHelper.linesToList(this.excludeArea.getText()));
    }

    public static boolean showEditor(Window window, FeaturePattern pattern) {
        FeaturePatternDialog dialog = new FeaturePatternDialog(window, pattern);
        dialog.setVisible(true);
        return dialog.saved;
    }
}

