/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.skcraft.launcher.swing.DirectoryField;
import com.skcraft.launcher.swing.SwingHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class DeployServerDialog
extends JDialog {
    private final DirectoryField destDirField = new DirectoryField();
    private final JCheckBox cleanModsCheck = new JCheckBox("Delete \"mods/\" folder before deploying");
    private DeployOptions options;

    public DeployServerDialog(Window parent) {
        super(parent, "Deploy Server Files", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.cleanModsCheck.setSelected(true);
    }

    private void initComponents() {
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets dialog"));
        container.add(new JLabel("Output Directory:"));
        container.add((Component)this.destDirField, "span");
        container.add((Component)this.cleanModsCheck, "span, gapbottom unrel");
        JButton buildButton = new JButton("Deploy");
        JButton cancelButton = new JButton("Cancel");
        container.add((Component)buildButton, "tag ok, span, split 2, sizegroup bttn");
        container.add((Component)cancelButton, "tag cancel, sizegroup bttn");
        this.add((Component)container, "Center");
        this.getRootPane().setDefaultButton(buildButton);
        this.getRootPane().registerKeyboardAction(e -> cancelButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        buildButton.addActionListener(e -> this.returnValue());
        cancelButton.addActionListener(e -> this.dispose());
    }

    private void returnValue() {
        String dir = this.destDirField.getPath();
        if (dir.isEmpty()) {
            SwingHelper.showErrorDialog(this, "A directory must be entered.", "Error");
            return;
        }
        File dirFile = new File(dir);
        if (!dirFile.isDirectory()) {
            SwingHelper.showErrorDialog(this, "The selected path is not a directory that exists.", "Error");
            return;
        }
        this.options = new DeployOptions(dirFile, this.cleanModsCheck.isSelected());
        this.dispose();
    }

    public static DeployOptions showDeployDialog(Window parent, File destDir) {
        DeployServerDialog dialog = new DeployServerDialog(parent);
        if (destDir != null) {
            dialog.destDirField.setPath(destDir.getAbsolutePath());
        }
        dialog.setVisible(true);
        return dialog.getOptions();
    }

    public DeployOptions getOptions() {
        return this.options;
    }

    public static class DeployOptions {
        private final File destDir;
        private final boolean cleanMods;

        public DeployOptions(File destDir, boolean cleanMods) {
            this.destDir = destDir;
            this.cleanMods = cleanMods;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public boolean isCleanMods() {
            return this.cleanMods;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeployOptions)) {
                return false;
            }
            DeployOptions other = (DeployOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCleanMods() != other.isCleanMods()) {
                return false;
            }
            File this$destDir = this.getDestDir();
            File other$destDir = other.getDestDir();
            return !(this$destDir == null ? other$destDir != null : !((Object)this$destDir).equals(other$destDir));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeployOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCleanMods() ? 79 : 97);
            File $destDir = this.getDestDir();
            result = result * 59 + ($destDir == null ? 43 : ((Object)$destDir).hashCode());
            return result;
        }

        public String toString() {
            return "DeployServerDialog.DeployOptions(destDir=" + this.getDestDir() + ", cleanMods=" + this.isCleanMods() + ")";
        }
    }
}

