/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.google.common.base.Strings;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TableSearchable;
import com.skcraft.launcher.builder.BuilderConfig;
import com.skcraft.launcher.builder.FeaturePattern;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.creator.dialog.FeaturePatternDialog;
import com.skcraft.launcher.creator.dialog.FeaturePatternTable;
import com.skcraft.launcher.creator.model.swing.FeaturePatternTableModel;
import com.skcraft.launcher.model.modpack.LaunchModifier;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class BuilderConfigDialog
extends JDialog {
    private final JTextField nameText = new JTextField(20);
    private final JTextField titleText = new JTextField(30);
    private final JTextField gameVersionText = new JTextField(10);
    private final JTextArea launchFlagsArea = new JTextArea(10, 40);
    private final JTextArea userFilesIncludeArea = new JTextArea(15, 40);
    private final JTextArea userFilesExcludeArea = new JTextArea(8, 40);
    private final FeaturePatternTable featuresTable = new FeaturePatternTable();
    private FeaturePatternTableModel featuresModel;
    private final BuilderConfig config;
    private boolean saved = false;

    public BuilderConfigDialog(Window parent, BuilderConfig config) {
        super(parent, "Modpack Properties", Dialog.ModalityType.DOCUMENT_MODAL);
        this.config = config;
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.copyFrom();
        this.nameText.requestFocus();
    }

    private void initComponents() {
        this.nameText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.titleText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.gameVersionText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.launchFlagsArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.userFilesIncludeArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.launchFlagsArea.setFont(this.nameText.getFont());
        this.userFilesIncludeArea.setFont(this.nameText.getFont());
        this.userFilesExcludeArea.setFont(this.nameText.getFont());
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("fill, insets dialog"));
        tabbedPane.addTab("Modpack", null, this.createMainPanel());
        tabbedPane.addTab("Launch", null, this.createLaunchPanel());
        tabbedPane.addTab("User Files", null, this.createUserFilesPanel());
        tabbedPane.addTab("Optional Features", null, this.createFeaturesPanel());
        container.add((Component)tabbedPane, "span, grow, gapbottom unrel");
        JButton saveButton = new JButton("Save");
        JButton cancelButton = new JButton("Cancel");
        container.add((Component)saveButton, "tag ok, span, split 2, sizegroup bttn");
        container.add((Component)cancelButton, "tag cancel, sizegroup bttn");
        this.getRootPane().setDefaultButton(saveButton);
        this.getRootPane().registerKeyboardAction(event -> cancelButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        this.add((Component)container, "Center");
        saveButton.addActionListener(e -> {
            if (this.nameText.getText().trim().isEmpty()) {
                SwingHelper.showErrorDialog(this, "The 'Name' field cannot be empty.", "Input Error");
                return;
            }
            if (this.gameVersionText.getText().trim().isEmpty()) {
                SwingHelper.showErrorDialog(this, "The 'Game Version' field must be a Minecraft version.", "Input Error");
                return;
            }
            this.copyTo();
            this.saved = true;
            this.dispose();
        });
        cancelButton.addActionListener(e -> this.dispose());
        TableSearchable tableSearchable = SearchableUtils.installSearchable(this.featuresTable);
        tableSearchable.setMainIndex(-1);
    }

    private JPanel createMainPanel() {
        JPanel container = new JPanel();
        SwingHelper.removeOpaqueness(container);
        container.setLayout(new MigLayout("insets dialog"));
        container.add(new JLabel("Name:"));
        container.add((Component)this.nameText, "span");
        container.add(new JLabel("Title:"));
        container.add((Component)this.titleText, "span");
        container.add(new JLabel("Game Version:"));
        container.add((Component)this.gameVersionText, "span");
        return container;
    }

    private JPanel createLaunchPanel() {
        JPanel container = new JPanel();
        SwingHelper.removeOpaqueness(container);
        container.setLayout(new MigLayout("insets dialog"));
        container.add((Component)new JLabel("Launch Flags:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.launchFlagsArea), "span");
        return container;
    }

    private JPanel createUserFilesPanel() {
        JPanel container = new JPanel();
        SwingHelper.removeOpaqueness(container);
        container.setLayout(new MigLayout("insets dialog"));
        container.add((Component)new JLabel("Include Patterns:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.userFilesIncludeArea), "span, gapbottom unrel");
        container.add((Component)new JLabel("Exclude Patterns:"), "wrap");
        container.add((Component)SwingHelper.wrapScrollPane(this.userFilesExcludeArea), "span");
        return container;
    }

    private JPanel createFeaturesPanel() {
        JPanel container = new JPanel();
        SwingHelper.removeOpaqueness(container);
        container.setLayout(new MigLayout("fill, insets dialog"));
        JButton newButton = new JButton("New...");
        JButton editButton = new JButton("Edit...");
        JButton deleteButton = new JButton("Delete...");
        container.add((Component)newButton, "span, split 3, sizegroup bttn");
        container.add((Component)editButton, "sizegroup bttn");
        container.add((Component)deleteButton, "sizegroup bttn");
        container.add((Component)SwingHelper.wrapScrollPane(this.featuresTable), "grow, w 10:100:null, gaptop 10");
        newButton.addActionListener(e -> {
            FeaturePattern pattern = new FeaturePattern();
            if (FeaturePatternDialog.showEditor(this, pattern)) {
                this.featuresModel.addFeature(pattern);
            }
        });
        editButton.addActionListener(e -> {
            int index = this.featuresTable.getSelectedRow();
            if (index > -1) {
                FeaturePattern pattern = this.featuresModel.getFeature(index);
                FeaturePatternDialog.showEditor(this, pattern);
                this.featuresModel.fireTableDataChanged();
            } else {
                SwingHelper.showErrorDialog(this, "Select a feature first.", "No Selection");
            }
        });
        deleteButton.addActionListener(e -> {
            int index = this.featuresTable.getSelectedRow();
            if (index > -1) {
                FeaturePattern pattern = this.featuresModel.getFeature(index);
                if (SwingHelper.confirmDialog(this, "Are you sure that you want to delete '" + pattern.getFeature().getName() + "'?", "Delete")) {
                    this.featuresModel.removeFeature(index);
                }
            } else {
                SwingHelper.showErrorDialog(this, "Select a feature first.", "No Selection");
            }
        });
        return container;
    }

    private void copyFrom() {
        SwingHelper.setTextAndResetCaret(this.nameText, this.config.getName());
        SwingHelper.setTextAndResetCaret(this.titleText, this.config.getTitle());
        SwingHelper.setTextAndResetCaret(this.gameVersionText, this.config.getGameVersion());
        SwingHelper.setTextAndResetCaret(this.launchFlagsArea, SwingHelper.listToLines(this.config.getLaunchModifier().getFlags()));
        SwingHelper.setTextAndResetCaret(this.userFilesIncludeArea, SwingHelper.listToLines(this.config.getUserFiles().getInclude()));
        SwingHelper.setTextAndResetCaret(this.userFilesExcludeArea, SwingHelper.listToLines(this.config.getUserFiles().getExclude()));
        this.featuresModel = new FeaturePatternTableModel(this.config.getFeatures());
        this.featuresTable.setModel(this.featuresModel);
    }

    private void copyTo() {
        this.config.setName(this.nameText.getText().trim());
        this.config.setTitle(Strings.emptyToNull(this.titleText.getText().trim()));
        this.config.setGameVersion(this.gameVersionText.getText().trim());
        LaunchModifier launchModifier = this.config.getLaunchModifier();
        FnPatternList userFiles = this.config.getUserFiles();
        launchModifier.setFlags(SwingHelper.linesToList(this.launchFlagsArea.getText()));
        userFiles.setInclude(SwingHelper.linesToList(this.userFilesIncludeArea.getText()));
        userFiles.setExclude(SwingHelper.linesToList(this.userFilesExcludeArea.getText()));
    }

    public static boolean showEditor(Window window, BuilderConfig config) {
        BuilderConfigDialog dialog = new BuilderConfigDialog(window, config);
        dialog.setVisible(true);
        return dialog.saved;
    }
}

