/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.skcraft.launcher.swing.DirectoryField;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class BuildDialog
extends JDialog {
    private final DirectoryField destDirField = new DirectoryField();
    private final JTextField versionText = new JTextField(20);
    private final JTextField manifestFilenameText = new JTextField(30);
    private BuildOptions options;

    public BuildDialog(Window parent) {
        super(parent, "Build Release", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.versionText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.manifestFilenameText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets dialog"));
        container.add(new JLabel("Version:"));
        container.add((Component)this.versionText, "span");
        container.add(new JLabel("Manifest Filename:"));
        container.add((Component)this.manifestFilenameText, "span");
        container.add(new JLabel("Output Directory:"));
        container.add((Component)this.destDirField, "span");
        JButton buildButton = new JButton("Build");
        JButton cancelButton = new JButton("Cancel");
        container.add((Component)buildButton, "tag ok, span, split 2, sizegroup bttn");
        container.add((Component)cancelButton, "tag cancel, sizegroup bttn");
        this.add((Component)container, "Center");
        this.getRootPane().setDefaultButton(buildButton);
        this.getRootPane().registerKeyboardAction(e -> cancelButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        buildButton.addActionListener(e -> this.returnValue());
        cancelButton.addActionListener(e -> this.dispose());
    }

    private void returnValue() {
        String version = this.versionText.getText().trim();
        String manifestFilename = this.manifestFilenameText.getText().trim();
        if (version.isEmpty()) {
            SwingHelper.showErrorDialog(this, "A version string must be entered.", "Error");
            return;
        }
        if (manifestFilename.isEmpty()) {
            SwingHelper.showErrorDialog(this, "A manifest filename must be entered.", "Error");
            return;
        }
        if (this.destDirField.getPath().isEmpty()) {
            SwingHelper.showErrorDialog(this, "A destination directory must be entered.", "Error");
            return;
        }
        this.options = new BuildOptions(version, manifestFilename, new File(this.destDirField.getPath()));
        this.dispose();
    }

    public static BuildOptions showBuildDialog(Window parent, String version, String manifestName, File destDir) {
        BuildDialog dialog = new BuildDialog(parent);
        dialog.versionText.setText(version);
        dialog.manifestFilenameText.setText(manifestName);
        dialog.destDirField.setPath(destDir.getAbsolutePath());
        dialog.setVisible(true);
        return dialog.getOptions();
    }

    public BuildOptions getOptions() {
        return this.options;
    }

    public static class BuildOptions {
        private final String version;
        private final String manifestFilename;
        private final File destDir;

        public BuildOptions(String version, String manifestFilename, File destDir) {
            this.version = version;
            this.manifestFilename = manifestFilename;
            this.destDir = destDir;
        }

        public String getVersion() {
            return this.version;
        }

        public String getManifestFilename() {
            return this.manifestFilename;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildOptions)) {
                return false;
            }
            BuildOptions other = (BuildOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$manifestFilename = this.getManifestFilename();
            String other$manifestFilename = other.getManifestFilename();
            if (this$manifestFilename == null ? other$manifestFilename != null : !this$manifestFilename.equals(other$manifestFilename)) {
                return false;
            }
            File this$destDir = this.getDestDir();
            File other$destDir = other.getDestDir();
            return !(this$destDir == null ? other$destDir != null : !((Object)this$destDir).equals(other$destDir));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BuildOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $manifestFilename = this.getManifestFilename();
            result = result * 59 + ($manifestFilename == null ? 43 : $manifestFilename.hashCode());
            File $destDir = this.getDestDir();
            result = result * 59 + ($destDir == null ? 43 : ((Object)$destDir).hashCode());
            return result;
        }

        public String toString() {
            return "BuildDialog.BuildOptions(version=" + this.getVersion() + ", manifestFilename=" + this.getManifestFilename() + ", destDir=" + this.getDestDir() + ")";
        }
    }
}

