/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.InstanceList;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.launch.LaunchOptions;
import com.skcraft.launcher.swing.SwingHelper;
import java.awt.Window;
import java.util.List;

public class TestLauncher
implements Function<InstanceList, Instance>,
ProgressObservable {
    private final Launcher launcher;
    private final Window window;
    private final String id;
    private final Session session;

    public TestLauncher(Launcher launcher, Window window, String id, Session session) {
        this.launcher = launcher;
        this.window = window;
        this.id = id;
        this.session = session;
    }

    private Optional<Instance> findInstance(List<Instance> instances) {
        for (Instance instance : instances) {
            if (!instance.getName().equals(this.id)) continue;
            return Optional.fromNullable(instance);
        }
        return Optional.absent();
    }

    @Override
    public Instance apply(InstanceList instanceList) {
        Optional<Instance> optional = this.findInstance(instanceList.getInstances());
        if (optional.isPresent()) {
            LaunchOptions options = new LaunchOptions.Builder().setInstance(optional.get()).setUpdatePolicy(LaunchOptions.UpdatePolicy.ALWAYS_UPDATE).setWindow(this.window).setSession(this.session).build();
            this.launcher.getLaunchSupervisor().launch(options);
            return optional.get();
        }
        SwingHelper.showErrorDialog(this.window, "After generating the necessary files, it appears the modpack can't be found in the launcher. Did you change modpack.json while the launcher was launching?", "Launch Error");
        return null;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return "Launching the game...";
    }
}

