/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.builder.ServerCopyExport;
import com.skcraft.launcher.creator.dialog.DeployServerDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class ServerDeploy
implements Callable<ServerDeploy>,
ProgressObservable {
    private final File srcDir;
    private final DeployServerDialog.DeployOptions options;

    public ServerDeploy(File srcDir, DeployServerDialog.DeployOptions options) {
        this.srcDir = srcDir;
        this.options = options;
    }

    @Override
    public ServerDeploy call() throws Exception {
        File modsDir = new File(this.options.getDestDir(), "mods");
        if (this.options.isCleanMods() && modsDir.isDirectory()) {
            ArrayList<File> failures = new ArrayList<File>();
            try {
                LauncherUtils.interruptibleDelete(modsDir, failures);
            }
            catch (IOException e) {
                Thread.sleep(1000L);
                LauncherUtils.interruptibleDelete(modsDir, failures);
            }
            if (failures.size() > 0) {
                throw new LauncherException(failures.size() + " failed to delete", "There were " + failures.size() + " failures during cleaning.");
            }
        }
        String[] args = new String[]{"--source", this.srcDir.getAbsolutePath(), "--dest", this.options.getDestDir().getAbsolutePath()};
        ServerCopyExport.main(args);
        return this;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return "Deploying server files...";
    }
}

