/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.skcraft.launcher.util.MorePaths;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class DirectoryWalker
implements Callable<List<File>> {
    private final File dir;
    private FileFilter fileFilter = pathname -> true;
    private boolean recursive;

    public DirectoryWalker(File dir) {
        Preconditions.checkNotNull(dir, "dir");
        this.dir = dir;
    }

    @Override
    public List<File> call() throws IOException {
        File cur;
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException(this.dir.getAbsolutePath() + " is not a directory");
        }
        ArrayList<File> matched = Lists.newArrayList();
        HashSet seen = Sets.newHashSet();
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(this.dir);
        while ((cur = (File)queue.poll()) != null) {
            File[] files;
            String canonical = cur.getCanonicalPath();
            if (seen.contains(canonical) || !MorePaths.isSubDirectory(this.dir, cur) || (files = cur.listFiles()) == null) continue;
            for (File file : files) {
                if (this.recursive && file.isDirectory()) {
                    queue.add(file);
                }
                if (!this.fileFilter.accept(file)) continue;
                matched.add(file);
            }
        }
        return matched;
    }

    public File getDir() {
        return this.dir;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}

